/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 UVC (UB Value Code and Amount) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Value Code (CNE)
 * <li>Value Amount (MO)
 * </ul>
 */
public class UVC extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new UVC type
     */
    public UVC(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[2];    
        data[0] = new CNE(getMessage());
        data[1] = new MO(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Value Code (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CNE getValueCode() {
       CNE ret = null;
       try {
          ret = (CNE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Value Code (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CNE getUvc1_ValueCode() {
       CNE ret = null;
       try {
          ret = (CNE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Value Amount (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public MO getValueAmount() {
       MO ret = null;
       try {
          ret = (MO)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Value Amount (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public MO getUvc2_ValueAmount() {
       MO ret = null;
       try {
          ret = (MO)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

