/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.model.v26.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a EHC_E10_PRODUCT_SERVICE_LINE_INFO group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: PSL (Product/Service Line Item) <b> </b></li>
                 * <li>2: ADJ (Adjustment) <b>optional repeating</b></li>
 * </ul>
 */
public class EHC_E10_PRODUCT_SERVICE_LINE_INFO extends AbstractGroup {

    /** 
     * Creates a new EHC_E10_PRODUCT_SERVICE_LINE_INFO group
     */
    public EHC_E10_PRODUCT_SERVICE_LINE_INFO(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(PSL.class, true, false);
                          this.add(ADJ.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating EHC_E10_PRODUCT_SERVICE_LINE_INFO - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.6"
     */
    public String getVersion() {
       return "2.6";
    }



    /**
     * Returns
     * PSL (Product/Service Line Item) - creates it if necessary
     */
    public PSL getPSL() { 
       PSL ret = null;
       try {
          ret = (PSL)this.get("PSL");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ADJ (Adjustment) - creates it if necessary
     */
    public ADJ getADJ() { 
       ADJ ret = null;
       try {
          ret = (ADJ)this.get("ADJ");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ADJ (Adjustment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ADJ getADJ(int rep) { 
       ADJ ret = null;
       try {
          ret = (ADJ)this.get("ADJ", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ADJ 
     */ 
    public int getADJReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ADJ").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ADJ (Adjustment)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertADJ(ADJ structure, int rep) throws HL7Exception { 
       super.insertRepetition("ADJ", structure, rep);
    }


    /**
     * Inserts a specific repetition of ADJ (Adjustment)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public ADJ insertADJ(int rep) throws HL7Exception { 
       return (ADJ)super.insertRepetition("ADJ", rep);
    }


    /**
     * Removes a specific repetition of ADJ (Adjustment)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public ADJ removeADJ(int rep) throws HL7Exception { 
       return (ADJ)super.removeRepetition("ADJ", rep);
    }



}

