/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.model.v26.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a EHC_E24_PSL_ITEM_INFO group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: PSL (Product/Service Line Item) <b> </b></li>
                 * <li>2: AUT (Authorization Information) <b>optional </b></li>
                 * <li>3: EHC_E24_PAYER_ADJUSTMENT (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class EHC_E24_PSL_ITEM_INFO extends AbstractGroup {

    /** 
     * Creates a new EHC_E24_PSL_ITEM_INFO group
     */
    public EHC_E24_PSL_ITEM_INFO(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(PSL.class, true, false);
                          this.add(AUT.class, false, false);
                          this.add(EHC_E24_PAYER_ADJUSTMENT.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating EHC_E24_PSL_ITEM_INFO - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.6"
     */
    public String getVersion() {
       return "2.6";
    }



    /**
     * Returns
     * PSL (Product/Service Line Item) - creates it if necessary
     */
    public PSL getPSL() { 
       PSL ret = null;
       try {
          ret = (PSL)this.get("PSL");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * AUT (Authorization Information) - creates it if necessary
     */
    public AUT getAUT() { 
       AUT ret = null;
       try {
          ret = (AUT)this.get("AUT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PAYER_ADJUSTMENT (a Group object) - creates it if necessary
     */
    public EHC_E24_PAYER_ADJUSTMENT getPAYER_ADJUSTMENT() { 
       EHC_E24_PAYER_ADJUSTMENT ret = null;
       try {
          ret = (EHC_E24_PAYER_ADJUSTMENT)this.get("PAYER_ADJUSTMENT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PAYER_ADJUSTMENT (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public EHC_E24_PAYER_ADJUSTMENT getPAYER_ADJUSTMENT(int rep) { 
       EHC_E24_PAYER_ADJUSTMENT ret = null;
       try {
          ret = (EHC_E24_PAYER_ADJUSTMENT)this.get("PAYER_ADJUSTMENT", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PAYER_ADJUSTMENT 
     */ 
    public int getPAYER_ADJUSTMENTReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PAYER_ADJUSTMENT").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PAYER_ADJUSTMENT (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertPAYER_ADJUSTMENT(EHC_E24_PAYER_ADJUSTMENT structure, int rep) throws HL7Exception { 
       super.insertRepetition("PAYER_ADJUSTMENT", structure, rep);
    }


    /**
     * Inserts a specific repetition of PAYER_ADJUSTMENT (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public EHC_E24_PAYER_ADJUSTMENT insertPAYER_ADJUSTMENT(int rep) throws HL7Exception { 
       return (EHC_E24_PAYER_ADJUSTMENT)super.insertRepetition("PAYER_ADJUSTMENT", rep);
    }


    /**
     * Removes a specific repetition of PAYER_ADJUSTMENT (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public EHC_E24_PAYER_ADJUSTMENT removePAYER_ADJUSTMENT(int rep) throws HL7Exception { 
       return (EHC_E24_PAYER_ADJUSTMENT)super.removeRepetition("PAYER_ADJUSTMENT", rep);
    }



}

