/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.model.v26.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a MFN_M16_PURCHASING_VENDOR group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: VND (Purchasing Vendor) <b> </b></li>
                 * <li>2: MFN_M16_PACKAGING (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class MFN_M16_PURCHASING_VENDOR extends AbstractGroup {

    /** 
     * Creates a new MFN_M16_PURCHASING_VENDOR group
     */
    public MFN_M16_PURCHASING_VENDOR(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(VND.class, true, false);
                          this.add(MFN_M16_PACKAGING.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFN_M16_PURCHASING_VENDOR - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.6"
     */
    public String getVersion() {
       return "2.6";
    }



    /**
     * Returns
     * VND (Purchasing Vendor) - creates it if necessary
     */
    public VND getVND() { 
       VND ret = null;
       try {
          ret = (VND)this.get("VND");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PACKAGING (a Group object) - creates it if necessary
     */
    public MFN_M16_PACKAGING getPACKAGING() { 
       MFN_M16_PACKAGING ret = null;
       try {
          ret = (MFN_M16_PACKAGING)this.get("PACKAGING");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PACKAGING (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public MFN_M16_PACKAGING getPACKAGING(int rep) { 
       MFN_M16_PACKAGING ret = null;
       try {
          ret = (MFN_M16_PACKAGING)this.get("PACKAGING", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PACKAGING 
     */ 
    public int getPACKAGINGReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PACKAGING").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PACKAGING (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertPACKAGING(MFN_M16_PACKAGING structure, int rep) throws HL7Exception { 
       super.insertRepetition("PACKAGING", structure, rep);
    }


    /**
     * Inserts a specific repetition of PACKAGING (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public MFN_M16_PACKAGING insertPACKAGING(int rep) throws HL7Exception { 
       return (MFN_M16_PACKAGING)super.insertRepetition("PACKAGING", rep);
    }


    /**
     * Removes a specific repetition of PACKAGING (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public MFN_M16_PACKAGING removePACKAGING(int rep) throws HL7Exception { 
       return (MFN_M16_PACKAGING)super.removeRepetition("PACKAGING", rep);
    }



}

