/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.model.v26.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a ORD_O04_RESPONSE group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: ORD_O04_PATIENT (a Group object) <b>optional </b></li>
                 * <li>2: ORD_O04_ORDER_DIET (a Group object) <b> repeating</b></li>
                 * <li>3: ORD_O04_ORDER_TRAY (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class ORD_O04_RESPONSE extends AbstractGroup {

    /** 
     * Creates a new ORD_O04_RESPONSE group
     */
    public ORD_O04_RESPONSE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(ORD_O04_PATIENT.class, false, false);
                          this.add(ORD_O04_ORDER_DIET.class, true, true);
                          this.add(ORD_O04_ORDER_TRAY.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORD_O04_RESPONSE - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.6"
     */
    public String getVersion() {
       return "2.6";
    }



    /**
     * Returns
     * PATIENT (a Group object) - creates it if necessary
     */
    public ORD_O04_PATIENT getPATIENT() { 
       ORD_O04_PATIENT ret = null;
       try {
          ret = (ORD_O04_PATIENT)this.get("PATIENT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORDER_DIET (a Group object) - creates it if necessary
     */
    public ORD_O04_ORDER_DIET getORDER_DIET() { 
       ORD_O04_ORDER_DIET ret = null;
       try {
          ret = (ORD_O04_ORDER_DIET)this.get("ORDER_DIET");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORDER_DIET (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORD_O04_ORDER_DIET getORDER_DIET(int rep) { 
       ORD_O04_ORDER_DIET ret = null;
       try {
          ret = (ORD_O04_ORDER_DIET)this.get("ORDER_DIET", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORDER_DIET 
     */ 
    public int getORDER_DIETReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORDER_DIET").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORDER_DIET (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORDER_DIET(ORD_O04_ORDER_DIET structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORDER_DIET", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORDER_DIET (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public ORD_O04_ORDER_DIET insertORDER_DIET(int rep) throws HL7Exception { 
       return (ORD_O04_ORDER_DIET)super.insertRepetition("ORDER_DIET", rep);
    }


    /**
     * Removes a specific repetition of ORDER_DIET (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public ORD_O04_ORDER_DIET removeORDER_DIET(int rep) throws HL7Exception { 
       return (ORD_O04_ORDER_DIET)super.removeRepetition("ORDER_DIET", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * ORDER_TRAY (a Group object) - creates it if necessary
     */
    public ORD_O04_ORDER_TRAY getORDER_TRAY() { 
       ORD_O04_ORDER_TRAY ret = null;
       try {
          ret = (ORD_O04_ORDER_TRAY)this.get("ORDER_TRAY");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORDER_TRAY (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORD_O04_ORDER_TRAY getORDER_TRAY(int rep) { 
       ORD_O04_ORDER_TRAY ret = null;
       try {
          ret = (ORD_O04_ORDER_TRAY)this.get("ORDER_TRAY", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORDER_TRAY 
     */ 
    public int getORDER_TRAYReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORDER_TRAY").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORDER_TRAY (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORDER_TRAY(ORD_O04_ORDER_TRAY structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORDER_TRAY", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORDER_TRAY (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public ORD_O04_ORDER_TRAY insertORDER_TRAY(int rep) throws HL7Exception { 
       return (ORD_O04_ORDER_TRAY)super.insertRepetition("ORDER_TRAY", rep);
    }


    /**
     * Removes a specific repetition of ORDER_TRAY (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public ORD_O04_ORDER_TRAY removeORDER_TRAY(int rep) throws HL7Exception { 
       return (ORD_O04_ORDER_TRAY)super.removeRepetition("ORDER_TRAY", rep);
    }



}

