/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.model.v26.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a RAS_O17_ORDER group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: ORC (Common Order) <b> </b></li>
                 * <li>2: RAS_O17_TIMING (a Group object) <b>optional repeating</b></li>
                 * <li>3: RAS_O17_ORDER_DETAIL (a Group object) <b>optional </b></li>
                 * <li>4: RAS_O17_ENCODING (a Group object) <b>optional </b></li>
                 * <li>5: RAS_O17_ADMINISTRATION (a Group object) <b> repeating</b></li>
                 * <li>6: CTI (Clinical Trial Identification) <b>optional repeating</b></li>
 * </ul>
 */
public class RAS_O17_ORDER extends AbstractGroup {

    /** 
     * Creates a new RAS_O17_ORDER group
     */
    public RAS_O17_ORDER(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(ORC.class, true, false);
                          this.add(RAS_O17_TIMING.class, false, true);
                          this.add(RAS_O17_ORDER_DETAIL.class, false, false);
                          this.add(RAS_O17_ENCODING.class, false, false);
                          this.add(RAS_O17_ADMINISTRATION.class, true, true);
                          this.add(CTI.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RAS_O17_ORDER - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.6"
     */
    public String getVersion() {
       return "2.6";
    }



    /**
     * Returns
     * ORC (Common Order) - creates it if necessary
     */
    public ORC getORC() { 
       ORC ret = null;
       try {
          ret = (ORC)this.get("ORC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * TIMING (a Group object) - creates it if necessary
     */
    public RAS_O17_TIMING getTIMING() { 
       RAS_O17_TIMING ret = null;
       try {
          ret = (RAS_O17_TIMING)this.get("TIMING");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * TIMING (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RAS_O17_TIMING getTIMING(int rep) { 
       RAS_O17_TIMING ret = null;
       try {
          ret = (RAS_O17_TIMING)this.get("TIMING", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of TIMING 
     */ 
    public int getTIMINGReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("TIMING").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of TIMING (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertTIMING(RAS_O17_TIMING structure, int rep) throws HL7Exception { 
       super.insertRepetition("TIMING", structure, rep);
    }


    /**
     * Inserts a specific repetition of TIMING (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public RAS_O17_TIMING insertTIMING(int rep) throws HL7Exception { 
       return (RAS_O17_TIMING)super.insertRepetition("TIMING", rep);
    }


    /**
     * Removes a specific repetition of TIMING (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public RAS_O17_TIMING removeTIMING(int rep) throws HL7Exception { 
       return (RAS_O17_TIMING)super.removeRepetition("TIMING", rep);
    }



    /**
     * Returns
     * ORDER_DETAIL (a Group object) - creates it if necessary
     */
    public RAS_O17_ORDER_DETAIL getORDER_DETAIL() { 
       RAS_O17_ORDER_DETAIL ret = null;
       try {
          ret = (RAS_O17_ORDER_DETAIL)this.get("ORDER_DETAIL");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ENCODING (a Group object) - creates it if necessary
     */
    public RAS_O17_ENCODING getENCODING() { 
       RAS_O17_ENCODING ret = null;
       try {
          ret = (RAS_O17_ENCODING)this.get("ENCODING");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ADMINISTRATION (a Group object) - creates it if necessary
     */
    public RAS_O17_ADMINISTRATION getADMINISTRATION() { 
       RAS_O17_ADMINISTRATION ret = null;
       try {
          ret = (RAS_O17_ADMINISTRATION)this.get("ADMINISTRATION");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ADMINISTRATION (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RAS_O17_ADMINISTRATION getADMINISTRATION(int rep) { 
       RAS_O17_ADMINISTRATION ret = null;
       try {
          ret = (RAS_O17_ADMINISTRATION)this.get("ADMINISTRATION", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ADMINISTRATION 
     */ 
    public int getADMINISTRATIONReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ADMINISTRATION").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ADMINISTRATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertADMINISTRATION(RAS_O17_ADMINISTRATION structure, int rep) throws HL7Exception { 
       super.insertRepetition("ADMINISTRATION", structure, rep);
    }


    /**
     * Inserts a specific repetition of ADMINISTRATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public RAS_O17_ADMINISTRATION insertADMINISTRATION(int rep) throws HL7Exception { 
       return (RAS_O17_ADMINISTRATION)super.insertRepetition("ADMINISTRATION", rep);
    }


    /**
     * Removes a specific repetition of ADMINISTRATION (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public RAS_O17_ADMINISTRATION removeADMINISTRATION(int rep) throws HL7Exception { 
       return (RAS_O17_ADMINISTRATION)super.removeRepetition("ADMINISTRATION", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * CTI (Clinical Trial Identification) - creates it if necessary
     */
    public CTI getCTI() { 
       CTI ret = null;
       try {
          ret = (CTI)this.get("CTI");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * CTI (Clinical Trial Identification) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CTI getCTI(int rep) { 
       CTI ret = null;
       try {
          ret = (CTI)this.get("CTI", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of CTI 
     */ 
    public int getCTIReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("CTI").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of CTI (Clinical Trial Identification)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertCTI(CTI structure, int rep) throws HL7Exception { 
       super.insertRepetition("CTI", structure, rep);
    }


    /**
     * Inserts a specific repetition of CTI (Clinical Trial Identification)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public CTI insertCTI(int rep) throws HL7Exception { 
       return (CTI)super.insertRepetition("CTI", rep);
    }


    /**
     * Removes a specific repetition of CTI (Clinical Trial Identification)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public CTI removeCTI(int rep) throws HL7Exception { 
       return (CTI)super.removeRepetition("CTI", rep);
    }



}

