/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.model.v26.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a TCU_U10_TEST_CONFIGURATION group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: SPM (Specimen) <b>optional </b></li>
                 * <li>2: TCC (Test Code Configuration) <b> repeating</b></li>
 * </ul>
 */
public class TCU_U10_TEST_CONFIGURATION extends AbstractGroup {

    /** 
     * Creates a new TCU_U10_TEST_CONFIGURATION group
     */
    public TCU_U10_TEST_CONFIGURATION(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(SPM.class, false, false);
                          this.add(TCC.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating TCU_U10_TEST_CONFIGURATION - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.6"
     */
    public String getVersion() {
       return "2.6";
    }



    /**
     * Returns
     * SPM (Specimen) - creates it if necessary
     */
    public SPM getSPM() { 
       SPM ret = null;
       try {
          ret = (SPM)this.get("SPM");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * TCC (Test Code Configuration) - creates it if necessary
     */
    public TCC getTCC() { 
       TCC ret = null;
       try {
          ret = (TCC)this.get("TCC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * TCC (Test Code Configuration) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public TCC getTCC(int rep) { 
       TCC ret = null;
       try {
          ret = (TCC)this.get("TCC", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of TCC 
     */ 
    public int getTCCReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("TCC").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of TCC (Test Code Configuration)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertTCC(TCC structure, int rep) throws HL7Exception { 
       super.insertRepetition("TCC", structure, rep);
    }


    /**
     * Inserts a specific repetition of TCC (Test Code Configuration)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public TCC insertTCC(int rep) throws HL7Exception { 
       return (TCC)super.insertRepetition("TCC", rep);
    }


    /**
     * Removes a specific repetition of TCC (Test Code Configuration)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public TCC removeTCC(int rep) throws HL7Exception { 
       return (TCC)super.removeRepetition("TCC", rep);
    }



}

