/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a NMQ_N01 message structure (see chapter 14.3.1). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message Header) <b> </b></li>
                 * <li>2: SFT (Software Segment) <b>optional repeating</b></li>
                 * <li>3: UAC (User Authentication Credential Segment) <b>optional </b></li>
                 * <li>4: NMQ_N01_QRY_WITH_DETAIL (a Group object) <b>optional </b></li>
                 * <li>5: NMQ_N01_CLOCK_AND_STATISTICS (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class NMQ_N01 extends AbstractMessage  {

    /**
     * Creates a new NMQ_N01 message with DefaultModelClassFactory. 
     */ 
    public NMQ_N01() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new NMQ_N01 message with custom ModelClassFactory.
     */
    public NMQ_N01(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(SFT.class, false, true);
                          this.add(UAC.class, false, false);
                          this.add(NMQ_N01_QRY_WITH_DETAIL.class, false, false);
                          this.add(NMQ_N01_CLOCK_AND_STATISTICS.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating NMQ_N01 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.6"
     */
    public String getVersion() {
       return "2.6";
    }



    /**
     * Returns
     * MSH (Message Header) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * SFT (Software Segment) - creates it if necessary
     */
    public SFT getSFT() { 
       SFT ret = null;
       try {
          ret = (SFT)this.get("SFT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * SFT (Software Segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SFT getSFT(int rep) { 
       SFT ret = null;
       try {
          ret = (SFT)this.get("SFT", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of SFT 
     */ 
    public int getSFTReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("SFT").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of SFT (Software Segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertSFT(SFT structure, int rep) throws HL7Exception { 
       super.insertRepetition( "SFT", structure, rep);
    }


    /**
     * Inserts a specific repetition of SFT (Software Segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public SFT insertSFT(int rep) throws HL7Exception { 
       return (SFT)super.insertRepetition("SFT", rep);
    }


    /**
     * Removes a specific repetition of SFT (Software Segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public SFT removeSFT(int rep) throws HL7Exception { 
       return (SFT)super.removeRepetition("SFT", rep);
    }



    /**
     * Returns
     * UAC (User Authentication Credential Segment) - creates it if necessary
     */
    public UAC getUAC() { 
       UAC ret = null;
       try {
          ret = (UAC)this.get("UAC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QRY_WITH_DETAIL (a Group object) - creates it if necessary
     */
    public NMQ_N01_QRY_WITH_DETAIL getQRY_WITH_DETAIL() { 
       NMQ_N01_QRY_WITH_DETAIL ret = null;
       try {
          ret = (NMQ_N01_QRY_WITH_DETAIL)this.get("QRY_WITH_DETAIL");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * CLOCK_AND_STATISTICS (a Group object) - creates it if necessary
     */
    public NMQ_N01_CLOCK_AND_STATISTICS getCLOCK_AND_STATISTICS() { 
       NMQ_N01_CLOCK_AND_STATISTICS ret = null;
       try {
          ret = (NMQ_N01_CLOCK_AND_STATISTICS)this.get("CLOCK_AND_STATISTICS");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * CLOCK_AND_STATISTICS (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NMQ_N01_CLOCK_AND_STATISTICS getCLOCK_AND_STATISTICS(int rep) { 
       NMQ_N01_CLOCK_AND_STATISTICS ret = null;
       try {
          ret = (NMQ_N01_CLOCK_AND_STATISTICS)this.get("CLOCK_AND_STATISTICS", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of CLOCK_AND_STATISTICS 
     */ 
    public int getCLOCK_AND_STATISTICSReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("CLOCK_AND_STATISTICS").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of CLOCK_AND_STATISTICS (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertCLOCK_AND_STATISTICS(NMQ_N01_CLOCK_AND_STATISTICS structure, int rep) throws HL7Exception { 
       super.insertRepetition( "CLOCK_AND_STATISTICS", structure, rep);
    }


    /**
     * Inserts a specific repetition of CLOCK_AND_STATISTICS (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public NMQ_N01_CLOCK_AND_STATISTICS insertCLOCK_AND_STATISTICS(int rep) throws HL7Exception { 
       return (NMQ_N01_CLOCK_AND_STATISTICS)super.insertRepetition("CLOCK_AND_STATISTICS", rep);
    }


    /**
     * Removes a specific repetition of CLOCK_AND_STATISTICS (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public NMQ_N01_CLOCK_AND_STATISTICS removeCLOCK_AND_STATISTICS(int rep) throws HL7Exception { 
       return (NMQ_N01_CLOCK_AND_STATISTICS)super.removeRepetition("CLOCK_AND_STATISTICS", rep);
    }



}

