/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 DRG message segment (Diagnosis Related Group). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>DRG-1: Diagnostic Related Group (CNE) <b>optional </b>
     * <li>DRG-2: DRG Assigned Date/Time (DTM) <b>optional </b>
     * <li>DRG-3: DRG Approval Indicator (ID) <b>optional </b>
     * <li>DRG-4: DRG Grouper Review Code (IS) <b>optional </b>
     * <li>DRG-5: Outlier Type (CWE) <b>optional </b>
     * <li>DRG-6: Outlier Days (NM) <b>optional </b>
     * <li>DRG-7: Outlier Cost (CP) <b>optional </b>
     * <li>DRG-8: DRG Payor (IS) <b>optional </b>
     * <li>DRG-9: Outlier Reimbursement (CP) <b>optional </b>
     * <li>DRG-10: Confidential Indicator (ID) <b>optional </b>
     * <li>DRG-11: DRG Transfer Type (IS) <b>optional </b>
     * <li>DRG-12: Name of Coder (XPN) <b>optional </b>
     * <li>DRG-13: Grouper Status (CWE) <b>optional </b>
     * <li>DRG-14: PCCL Value Code (CWE) <b>optional </b>
     * <li>DRG-15: Effective Weight (NM) <b>optional </b>
     * <li>DRG-16: Monetary Amount (MO) <b>optional </b>
     * <li>DRG-17: Status Patient (IS) <b>optional </b>
     * <li>DRG-18: Grouper Software Name (ST) <b>optional </b>
     * <li>DRG-19: Grouper Software Version (ST) <b>optional </b>
     * <li>DRG-20: Status Financial Calculation (IS) <b>optional </b>
     * <li>DRG-21: Relative Discount/Surcharge (MO) <b>optional </b>
     * <li>DRG-22: Basic Charge (MO) <b>optional </b>
     * <li>DRG-23: Total Charge (MO) <b>optional </b>
     * <li>DRG-24: Discount/Surcharge (MO) <b>optional </b>
     * <li>DRG-25: Calculated Days (NM) <b>optional </b>
     * <li>DRG-26: Status Gender (IS) <b>optional </b>
     * <li>DRG-27: Status Age (IS) <b>optional </b>
     * <li>DRG-28: Status Length of Stay (IS) <b>optional </b>
     * <li>DRG-29: Status Same Day Flag (IS) <b>optional </b>
     * <li>DRG-30: Status Separation Mode (IS) <b>optional </b>
     * <li>DRG-31: Status Weight at Birth (IS) <b>optional </b>
     * <li>DRG-32: Status Respiration Minutes (IS) <b>optional </b>
     * <li>DRG-33: Status Admission (IS) <b>optional </b>
 * </ul>
 */
public class DRG extends AbstractSegment {

    /** 
     * Creates a new DRG segment
     */
    public DRG(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CNE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(55) }, "Diagnostic Related Group");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "DRG Assigned Date/Time");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "DRG Approval Indicator");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "DRG Grouper Review Code");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(83) }, "Outlier Type");
                                  this.add(NM.class, false, 1, 3, new Object[]{ getMessage(), new Integer(0) }, "Outlier Days");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Outlier Cost");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "DRG Payor");
                                  this.add(CP.class, false, 1, 9, new Object[]{ getMessage(), new Integer(0) }, "Outlier Reimbursement");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Confidential Indicator");
                                  this.add(IS.class, false, 1, 21, new Object[]{ getMessage() }, "DRG Transfer Type");
                                  this.add(XPN.class, false, 1, 1103, new Object[]{ getMessage(), new Integer(0) }, "Name of Coder");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(734) }, "Grouper Status");
                                  this.add(CWE.class, false, 1, 20, new Object[]{ getMessage(), new Integer(728) }, "PCCL Value Code");
                                  this.add(NM.class, false, 1, 5, new Object[]{ getMessage(), new Integer(0) }, "Effective Weight");
                                  this.add(MO.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Monetary Amount");
                                  this.add(IS.class, false, 1, 20, new Object[]{ getMessage() }, "Status Patient");
                                  this.add(ST.class, false, 1, 100, new Object[]{ getMessage(), new Integer(0) }, "Grouper Software Name");
                                  this.add(ST.class, false, 1, 100, new Object[]{ getMessage(), new Integer(0) }, "Grouper Software Version");
                                  this.add(IS.class, false, 1, 20, new Object[]{ getMessage() }, "Status Financial Calculation");
                                  this.add(MO.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Relative Discount/Surcharge");
                                  this.add(MO.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Basic Charge");
                                  this.add(MO.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Total Charge");
                                  this.add(MO.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Discount/Surcharge");
                                  this.add(NM.class, false, 1, 5, new Object[]{ getMessage(), new Integer(0) }, "Calculated Days");
                                  this.add(IS.class, false, 1, 20, new Object[]{ getMessage() }, "Status Gender");
                                  this.add(IS.class, false, 1, 20, new Object[]{ getMessage() }, "Status Age");
                                  this.add(IS.class, false, 1, 20, new Object[]{ getMessage() }, "Status Length of Stay");
                                  this.add(IS.class, false, 1, 20, new Object[]{ getMessage() }, "Status Same Day Flag");
                                  this.add(IS.class, false, 1, 20, new Object[]{ getMessage() }, "Status Separation Mode");
                                  this.add(IS.class, false, 1, 20, new Object[]{ getMessage() }, "Status Weight at Birth");
                                  this.add(IS.class, false, 1, 20, new Object[]{ getMessage() }, "Status Respiration Minutes");
                                  this.add(IS.class, false, 1, 20, new Object[]{ getMessage() }, "Status Admission");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating DRG - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * DRG-1: "Diagnostic Related Group" - creates it if necessary
     */
    public CNE getDiagnosticRelatedGroup() { 
        CNE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-1: "Diagnostic Related Group" - creates it if necessary
     */
    public CNE getDrg1_DiagnosticRelatedGroup() { 
        CNE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-2: "DRG Assigned Date/Time" - creates it if necessary
     */
    public DTM getDRGAssignedDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-2: "DRG Assigned Date/Time" - creates it if necessary
     */
    public DTM getDrg2_DRGAssignedDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-3: "DRG Approval Indicator" - creates it if necessary
     */
    public ID getDRGApprovalIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-3: "DRG Approval Indicator" - creates it if necessary
     */
    public ID getDrg3_DRGApprovalIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-4: "DRG Grouper Review Code" - creates it if necessary
     */
    public IS getDRGGrouperReviewCode() { 
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-4: "DRG Grouper Review Code" - creates it if necessary
     */
    public IS getDrg4_DRGGrouperReviewCode() { 
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-5: "Outlier Type" - creates it if necessary
     */
    public CWE getOutlierType() { 
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-5: "Outlier Type" - creates it if necessary
     */
    public CWE getDrg5_OutlierType() { 
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-6: "Outlier Days" - creates it if necessary
     */
    public NM getOutlierDays() { 
        NM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-6: "Outlier Days" - creates it if necessary
     */
    public NM getDrg6_OutlierDays() { 
        NM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-7: "Outlier Cost" - creates it if necessary
     */
    public CP getOutlierCost() { 
        CP ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-7: "Outlier Cost" - creates it if necessary
     */
    public CP getDrg7_OutlierCost() { 
        CP ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-8: "DRG Payor" - creates it if necessary
     */
    public IS getDRGPayor() { 
        IS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-8: "DRG Payor" - creates it if necessary
     */
    public IS getDrg8_DRGPayor() { 
        IS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-9: "Outlier Reimbursement" - creates it if necessary
     */
    public CP getOutlierReimbursement() { 
        CP ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-9: "Outlier Reimbursement" - creates it if necessary
     */
    public CP getDrg9_OutlierReimbursement() { 
        CP ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-10: "Confidential Indicator" - creates it if necessary
     */
    public ID getConfidentialIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-10: "Confidential Indicator" - creates it if necessary
     */
    public ID getDrg10_ConfidentialIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-11: "DRG Transfer Type" - creates it if necessary
     */
    public IS getDRGTransferType() { 
        IS ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-11: "DRG Transfer Type" - creates it if necessary
     */
    public IS getDrg11_DRGTransferType() { 
        IS ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-12: "Name of Coder" - creates it if necessary
     */
    public XPN getNameOfCoder() { 
        XPN ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-12: "Name of Coder" - creates it if necessary
     */
    public XPN getDrg12_NameOfCoder() { 
        XPN ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-13: "Grouper Status" - creates it if necessary
     */
    public CWE getGrouperStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-13: "Grouper Status" - creates it if necessary
     */
    public CWE getDrg13_GrouperStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-14: "PCCL Value Code" - creates it if necessary
     */
    public CWE getPCCLValueCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-14: "PCCL Value Code" - creates it if necessary
     */
    public CWE getDrg14_PCCLValueCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-15: "Effective Weight" - creates it if necessary
     */
    public NM getEffectiveWeight() { 
        NM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-15: "Effective Weight" - creates it if necessary
     */
    public NM getDrg15_EffectiveWeight() { 
        NM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-16: "Monetary Amount" - creates it if necessary
     */
    public MO getMonetaryAmount() { 
        MO ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-16: "Monetary Amount" - creates it if necessary
     */
    public MO getDrg16_MonetaryAmount() { 
        MO ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-17: "Status Patient" - creates it if necessary
     */
    public IS getStatusPatient() { 
        IS ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-17: "Status Patient" - creates it if necessary
     */
    public IS getDrg17_StatusPatient() { 
        IS ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-18: "Grouper Software Name" - creates it if necessary
     */
    public ST getGrouperSoftwareName() { 
        ST ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-18: "Grouper Software Name" - creates it if necessary
     */
    public ST getDrg18_GrouperSoftwareName() { 
        ST ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-19: "Grouper Software Version" - creates it if necessary
     */
    public ST getGrouperSoftwareVersion() { 
        ST ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-19: "Grouper Software Version" - creates it if necessary
     */
    public ST getDrg19_GrouperSoftwareVersion() { 
        ST ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-20: "Status Financial Calculation" - creates it if necessary
     */
    public IS getStatusFinancialCalculation() { 
        IS ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-20: "Status Financial Calculation" - creates it if necessary
     */
    public IS getDrg20_StatusFinancialCalculation() { 
        IS ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-21: "Relative Discount/Surcharge" - creates it if necessary
     */
    public MO getRelativeDiscountSurcharge() { 
        MO ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-21: "Relative Discount/Surcharge" - creates it if necessary
     */
    public MO getDrg21_RelativeDiscountSurcharge() { 
        MO ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-22: "Basic Charge" - creates it if necessary
     */
    public MO getBasicCharge() { 
        MO ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-22: "Basic Charge" - creates it if necessary
     */
    public MO getDrg22_BasicCharge() { 
        MO ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-23: "Total Charge" - creates it if necessary
     */
    public MO getTotalCharge() { 
        MO ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-23: "Total Charge" - creates it if necessary
     */
    public MO getDrg23_TotalCharge() { 
        MO ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-24: "Discount/Surcharge" - creates it if necessary
     */
    public MO getDiscountSurcharge() { 
        MO ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-24: "Discount/Surcharge" - creates it if necessary
     */
    public MO getDrg24_DiscountSurcharge() { 
        MO ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-25: "Calculated Days" - creates it if necessary
     */
    public NM getCalculatedDays() { 
        NM ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-25: "Calculated Days" - creates it if necessary
     */
    public NM getDrg25_CalculatedDays() { 
        NM ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-26: "Status Gender" - creates it if necessary
     */
    public IS getStatusGender() { 
        IS ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-26: "Status Gender" - creates it if necessary
     */
    public IS getDrg26_StatusGender() { 
        IS ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-27: "Status Age" - creates it if necessary
     */
    public IS getStatusAge() { 
        IS ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-27: "Status Age" - creates it if necessary
     */
    public IS getDrg27_StatusAge() { 
        IS ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-28: "Status Length of Stay" - creates it if necessary
     */
    public IS getStatusLengthOfStay() { 
        IS ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-28: "Status Length of Stay" - creates it if necessary
     */
    public IS getDrg28_StatusLengthOfStay() { 
        IS ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-29: "Status Same Day Flag" - creates it if necessary
     */
    public IS getStatusSameDayFlag() { 
        IS ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-29: "Status Same Day Flag" - creates it if necessary
     */
    public IS getDrg29_StatusSameDayFlag() { 
        IS ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-30: "Status Separation Mode" - creates it if necessary
     */
    public IS getStatusSeparationMode() { 
        IS ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-30: "Status Separation Mode" - creates it if necessary
     */
    public IS getDrg30_StatusSeparationMode() { 
        IS ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-31: "Status Weight at Birth" - creates it if necessary
     */
    public IS getStatusWeightAtBirth() { 
        IS ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-31: "Status Weight at Birth" - creates it if necessary
     */
    public IS getDrg31_StatusWeightAtBirth() { 
        IS ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-32: "Status Respiration Minutes" - creates it if necessary
     */
    public IS getStatusRespirationMinutes() { 
        IS ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-32: "Status Respiration Minutes" - creates it if necessary
     */
    public IS getDrg32_StatusRespirationMinutes() { 
        IS ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-33: "Status Admission" - creates it if necessary
     */
    public IS getStatusAdmission() { 
        IS ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-33: "Status Admission" - creates it if necessary
     */
    public IS getDrg33_StatusAdmission() { 
        IS ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CNE(getMessage());
          case 1: return new DTM(getMessage());
          case 2: return new ID(getMessage(), new Integer( 136 ));
          case 3: return new IS(getMessage(), new Integer( 56 ));
          case 4: return new CWE(getMessage());
          case 5: return new NM(getMessage());
          case 6: return new CP(getMessage());
          case 7: return new IS(getMessage(), new Integer( 229 ));
          case 8: return new CP(getMessage());
          case 9: return new ID(getMessage(), new Integer( 136 ));
          case 10: return new IS(getMessage(), new Integer( 415 ));
          case 11: return new XPN(getMessage());
          case 12: return new CWE(getMessage());
          case 13: return new CWE(getMessage());
          case 14: return new NM(getMessage());
          case 15: return new MO(getMessage());
          case 16: return new IS(getMessage(), new Integer( 739 ));
          case 17: return new ST(getMessage());
          case 18: return new ST(getMessage());
          case 19: return new IS(getMessage(), new Integer( 742 ));
          case 20: return new MO(getMessage());
          case 21: return new MO(getMessage());
          case 22: return new MO(getMessage());
          case 23: return new MO(getMessage());
          case 24: return new NM(getMessage());
          case 25: return new IS(getMessage(), new Integer( 749 ));
          case 26: return new IS(getMessage(), new Integer( 749 ));
          case 27: return new IS(getMessage(), new Integer( 749 ));
          case 28: return new IS(getMessage(), new Integer( 749 ));
          case 29: return new IS(getMessage(), new Integer( 749 ));
          case 30: return new IS(getMessage(), new Integer( 755 ));
          case 31: return new IS(getMessage(), new Integer( 757 ));
          case 32: return new IS(getMessage(), new Integer( 759 ));
          default: return null;
       }
   }


}

