/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 EVN message segment (Event Type). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>EVN-1: Event Type Code (ID) <b>optional </b>
     * <li>EVN-2: Recorded Date/Time (DTM) <b> </b>
     * <li>EVN-3: Date/Time Planned Event (DTM) <b>optional </b>
     * <li>EVN-4: Event Reason Code (IS) <b>optional </b>
     * <li>EVN-5: Operator ID (XCN) <b>optional repeating</b>
     * <li>EVN-6: Event Occurred (DTM) <b>optional </b>
     * <li>EVN-7: Event Facility (HD) <b>optional </b>
 * </ul>
 */
public class EVN extends AbstractSegment {

    /** 
     * Creates a new EVN segment
     */
    public EVN(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ID.class, false, 1, 0, new Object[]{ getMessage() }, "Event Type Code");
                                  this.add(DTM.class, true, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Recorded Date/Time");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Date/Time Planned Event");
                                  this.add(IS.class, false, 1, 3, new Object[]{ getMessage() }, "Event Reason Code");
                                  this.add(XCN.class, false, 0, 250, new Object[]{ getMessage(), new Integer(188) }, "Operator ID");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Event Occurred");
                                  this.add(HD.class, false, 1, 241, new Object[]{ getMessage(), new Integer(0) }, "Event Facility");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating EVN - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * EVN-1: "Event Type Code" - creates it if necessary
     */
    public ID getEventTypeCode() { 
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * EVN-1: "Event Type Code" - creates it if necessary
     */
    public ID getEvn1_EventTypeCode() { 
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * EVN-2: "Recorded Date/Time" - creates it if necessary
     */
    public DTM getRecordedDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * EVN-2: "Recorded Date/Time" - creates it if necessary
     */
    public DTM getEvn2_RecordedDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * EVN-3: "Date/Time Planned Event" - creates it if necessary
     */
    public DTM getDateTimePlannedEvent() { 
        DTM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * EVN-3: "Date/Time Planned Event" - creates it if necessary
     */
    public DTM getEvn3_DateTimePlannedEvent() { 
        DTM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * EVN-4: "Event Reason Code" - creates it if necessary
     */
    public IS getEventReasonCode() { 
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * EVN-4: "Event Reason Code" - creates it if necessary
     */
    public IS getEvn4_EventReasonCode() { 
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Operator ID (EVN-5).
     */
    public XCN[] getOperatorID() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(5);  
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XCN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Operator ID (EVN-5).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOperatorIDReps() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * EVN-5: "Operator ID" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getOperatorID(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * EVN-5: "Operator ID" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getEvn5_OperatorID(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Operator ID (EVN-5).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getEvn5_OperatorIDReps() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * EVN-5: "Operator ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertOperatorID(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(5, rep);
    }



    /**
     * Inserts a repetition of
     * EVN-5: "Operator ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertEvn5_OperatorID(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * EVN-5: "Operator ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeOperatorID(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * EVN-5: "Operator ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeEvn5_OperatorID(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(5, rep);
    }




    /**
     * Returns
     * EVN-6: "Event Occurred" - creates it if necessary
     */
    public DTM getEventOccurred() { 
        DTM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * EVN-6: "Event Occurred" - creates it if necessary
     */
    public DTM getEvn6_EventOccurred() { 
        DTM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * EVN-7: "Event Facility" - creates it if necessary
     */
    public HD getEventFacility() { 
        HD ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (HD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * EVN-7: "Event Facility" - creates it if necessary
     */
    public HD getEvn7_EventFacility() { 
        HD ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (HD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ID(getMessage(), new Integer( 3 ));
          case 1: return new DTM(getMessage());
          case 2: return new DTM(getMessage());
          case 3: return new IS(getMessage(), new Integer( 62 ));
          case 4: return new XCN(getMessage());
          case 5: return new DTM(getMessage());
          case 6: return new HD(getMessage());
          default: return null;
       }
   }


}

