/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 IVT message segment (Material Location). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>IVT-1: Set Id - IVT (SI) <b> </b>
     * <li>IVT-2: Inventory Location Identifier (EI) <b> </b>
     * <li>IVT-3: Inventory Location Name (ST) <b>optional </b>
     * <li>IVT-4: Source Location Identifier (EI) <b>optional </b>
     * <li>IVT-5: Source Location Name (ST) <b>optional </b>
     * <li>IVT-6: Item Status (CWE) <b>optional </b>
     * <li>IVT-7: Bin Location Identifier (EI) <b>optional repeating</b>
     * <li>IVT-8: Order Packaging (CWE) <b>optional </b>
     * <li>IVT-9: Issue Packaging (CWE) <b>optional </b>
     * <li>IVT-10: Default Inventory Asset Account (EI) <b>optional </b>
     * <li>IVT-11: Patient Chargeable Indicator (CNE) <b>optional </b>
     * <li>IVT-12: Transaction Code (CWE) <b>optional </b>
     * <li>IVT-13: Transaction amount - unit (CP) <b>optional </b>
     * <li>IVT-14: Item Importance Code (CWE) <b>optional </b>
     * <li>IVT-15: Stocked Item Indicator (CNE) <b>optional </b>
     * <li>IVT-16: Consignment Item Indicator (CNE) <b>optional </b>
     * <li>IVT-17: Reusable Item Indicator (CNE) <b>optional </b>
     * <li>IVT-18: Reusable Cost (CP) <b>optional </b>
     * <li>IVT-19: Substitute Item Identifier (EI) <b>optional repeating</b>
     * <li>IVT-20: Latex-Free Substitute Item Identifier (EI) <b>optional </b>
     * <li>IVT-21: Recommended Reorder Theory (CWE) <b>optional </b>
     * <li>IVT-22: Recommended Safety Stock Days (NM) <b>optional </b>
     * <li>IVT-23: Recommended Maximum Days Inventory (NM) <b>optional </b>
     * <li>IVT-24: Recommended Order Point (NM) <b>optional </b>
     * <li>IVT-25: Recommended Order Amount (NM) <b>optional </b>
     * <li>IVT-26: Operating Room Par Level Indicator (CNE) <b>optional </b>
 * </ul>
 */
public class IVT extends AbstractSegment {

    /** 
     * Creates a new IVT segment
     */
    public IVT(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set Id - IVT");
                                  this.add(EI.class, true, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Inventory Location Identifier");
                                  this.add(ST.class, false, 1, 999, new Object[]{ getMessage(), new Integer(0) }, "Inventory Location Name");
                                  this.add(EI.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Source Location Identifier");
                                  this.add(ST.class, false, 1, 999, new Object[]{ getMessage(), new Integer(0) }, "Source Location Name");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(625) }, "Item Status");
                                  this.add(EI.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Bin Location Identifier");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Order Packaging");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Issue Packaging");
                                  this.add(EI.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Default Inventory Asset Account");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Patient Chargeable Indicator");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(132) }, "Transaction Code");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Transaction amount - unit");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(634) }, "Item Importance Code");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Stocked Item Indicator");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Consignment Item Indicator");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Reusable Item Indicator");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Reusable Cost");
                                  this.add(EI.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Substitute Item Identifier");
                                  this.add(EI.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Latex-Free Substitute Item Identifier");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(642) }, "Recommended Reorder Theory");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Recommended Safety Stock Days");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Recommended Maximum Days Inventory");
                                  this.add(NM.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Recommended Order Point");
                                  this.add(NM.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Recommended Order Amount");
                                  this.add(CNE.class, false, 1, 4, new Object[]{ getMessage(), new Integer(532) }, "Operating Room Par Level Indicator");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating IVT - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * IVT-1: "Set Id - IVT" - creates it if necessary
     */
    public SI getSetIdIVT() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-1: "Set Id - IVT" - creates it if necessary
     */
    public SI getIvt1_SetIdIVT() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-2: "Inventory Location Identifier" - creates it if necessary
     */
    public EI getInventoryLocationIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-2: "Inventory Location Identifier" - creates it if necessary
     */
    public EI getIvt2_InventoryLocationIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-3: "Inventory Location Name" - creates it if necessary
     */
    public ST getInventoryLocationName() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-3: "Inventory Location Name" - creates it if necessary
     */
    public ST getIvt3_InventoryLocationName() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-4: "Source Location Identifier" - creates it if necessary
     */
    public EI getSourceLocationIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-4: "Source Location Identifier" - creates it if necessary
     */
    public EI getIvt4_SourceLocationIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-5: "Source Location Name" - creates it if necessary
     */
    public ST getSourceLocationName() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-5: "Source Location Name" - creates it if necessary
     */
    public ST getIvt5_SourceLocationName() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-6: "Item Status" - creates it if necessary
     */
    public CWE getItemStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-6: "Item Status" - creates it if necessary
     */
    public CWE getIvt6_ItemStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Bin Location Identifier (IVT-7).
     */
    public EI[] getBinLocationIdentifier() {
        EI[] ret = null;
        try {
            Type[] t = this.getField(7);  
            ret = new EI[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (EI)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Bin Location Identifier (IVT-7).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getBinLocationIdentifierReps() {
        EI[] ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IVT-7: "Bin Location Identifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public EI getBinLocationIdentifier(int rep) { 
        EI ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IVT-7: "Bin Location Identifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public EI getIvt7_BinLocationIdentifier(int rep) { 
        EI ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Bin Location Identifier (IVT-7).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIvt7_BinLocationIdentifierReps() {
        EI[] ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IVT-7: "Bin Location Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI insertBinLocationIdentifier(int rep) throws HL7Exception { 
        return (EI) super.insertRepetition(7, rep);
    }



    /**
     * Inserts a repetition of
     * IVT-7: "Bin Location Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI insertIvt7_BinLocationIdentifier(int rep) throws HL7Exception { 
        return (EI) super.insertRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * IVT-7: "Bin Location Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI removeBinLocationIdentifier(int rep) throws HL7Exception { 
        return (EI) super.removeRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * IVT-7: "Bin Location Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI removeIvt7_BinLocationIdentifier(int rep) throws HL7Exception { 
        return (EI) super.removeRepetition(7, rep);
    }




    /**
     * Returns
     * IVT-8: "Order Packaging" - creates it if necessary
     */
    public CWE getOrderPackaging() { 
        CWE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-8: "Order Packaging" - creates it if necessary
     */
    public CWE getIvt8_OrderPackaging() { 
        CWE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-9: "Issue Packaging" - creates it if necessary
     */
    public CWE getIssuePackaging() { 
        CWE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-9: "Issue Packaging" - creates it if necessary
     */
    public CWE getIvt9_IssuePackaging() { 
        CWE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-10: "Default Inventory Asset Account" - creates it if necessary
     */
    public EI getDefaultInventoryAssetAccount() { 
        EI ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-10: "Default Inventory Asset Account" - creates it if necessary
     */
    public EI getIvt10_DefaultInventoryAssetAccount() { 
        EI ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-11: "Patient Chargeable Indicator" - creates it if necessary
     */
    public CNE getPatientChargeableIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-11: "Patient Chargeable Indicator" - creates it if necessary
     */
    public CNE getIvt11_PatientChargeableIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-12: "Transaction Code" - creates it if necessary
     */
    public CWE getTransactionCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-12: "Transaction Code" - creates it if necessary
     */
    public CWE getIvt12_TransactionCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-13: "Transaction amount - unit" - creates it if necessary
     */
    public CP getTransactionAmountUnit() { 
        CP ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-13: "Transaction amount - unit" - creates it if necessary
     */
    public CP getIvt13_TransactionAmountUnit() { 
        CP ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-14: "Item Importance Code" - creates it if necessary
     */
    public CWE getItemImportanceCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-14: "Item Importance Code" - creates it if necessary
     */
    public CWE getIvt14_ItemImportanceCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-15: "Stocked Item Indicator" - creates it if necessary
     */
    public CNE getStockedItemIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-15: "Stocked Item Indicator" - creates it if necessary
     */
    public CNE getIvt15_StockedItemIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-16: "Consignment Item Indicator" - creates it if necessary
     */
    public CNE getConsignmentItemIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-16: "Consignment Item Indicator" - creates it if necessary
     */
    public CNE getIvt16_ConsignmentItemIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-17: "Reusable Item Indicator" - creates it if necessary
     */
    public CNE getReusableItemIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-17: "Reusable Item Indicator" - creates it if necessary
     */
    public CNE getIvt17_ReusableItemIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-18: "Reusable Cost" - creates it if necessary
     */
    public CP getReusableCost() { 
        CP ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-18: "Reusable Cost" - creates it if necessary
     */
    public CP getIvt18_ReusableCost() { 
        CP ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Substitute Item Identifier (IVT-19).
     */
    public EI[] getSubstituteItemIdentifier() {
        EI[] ret = null;
        try {
            Type[] t = this.getField(19);  
            ret = new EI[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (EI)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Substitute Item Identifier (IVT-19).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getSubstituteItemIdentifierReps() {
        EI[] ret = null;
        try {
            Type[] t = this.getField(19);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IVT-19: "Substitute Item Identifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public EI getSubstituteItemIdentifier(int rep) { 
        EI ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IVT-19: "Substitute Item Identifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public EI getIvt19_SubstituteItemIdentifier(int rep) { 
        EI ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Substitute Item Identifier (IVT-19).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIvt19_SubstituteItemIdentifierReps() {
        EI[] ret = null;
        try {
            Type[] t = this.getField(19);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IVT-19: "Substitute Item Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI insertSubstituteItemIdentifier(int rep) throws HL7Exception { 
        return (EI) super.insertRepetition(19, rep);
    }



    /**
     * Inserts a repetition of
     * IVT-19: "Substitute Item Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI insertIvt19_SubstituteItemIdentifier(int rep) throws HL7Exception { 
        return (EI) super.insertRepetition(19, rep);
    }


    /**
     * Removes a repetition of
     * IVT-19: "Substitute Item Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI removeSubstituteItemIdentifier(int rep) throws HL7Exception { 
        return (EI) super.removeRepetition(19, rep);
    }


    /**
     * Removes a repetition of
     * IVT-19: "Substitute Item Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI removeIvt19_SubstituteItemIdentifier(int rep) throws HL7Exception { 
        return (EI) super.removeRepetition(19, rep);
    }




    /**
     * Returns
     * IVT-20: "Latex-Free Substitute Item Identifier" - creates it if necessary
     */
    public EI getLatexFreeSubstituteItemIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-20: "Latex-Free Substitute Item Identifier" - creates it if necessary
     */
    public EI getIvt20_LatexFreeSubstituteItemIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-21: "Recommended Reorder Theory" - creates it if necessary
     */
    public CWE getRecommendedReorderTheory() { 
        CWE ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-21: "Recommended Reorder Theory" - creates it if necessary
     */
    public CWE getIvt21_RecommendedReorderTheory() { 
        CWE ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-22: "Recommended Safety Stock Days" - creates it if necessary
     */
    public NM getRecommendedSafetyStockDays() { 
        NM ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-22: "Recommended Safety Stock Days" - creates it if necessary
     */
    public NM getIvt22_RecommendedSafetyStockDays() { 
        NM ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-23: "Recommended Maximum Days Inventory" - creates it if necessary
     */
    public NM getRecommendedMaximumDaysInventory() { 
        NM ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-23: "Recommended Maximum Days Inventory" - creates it if necessary
     */
    public NM getIvt23_RecommendedMaximumDaysInventory() { 
        NM ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-24: "Recommended Order Point" - creates it if necessary
     */
    public NM getRecommendedOrderPoint() { 
        NM ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-24: "Recommended Order Point" - creates it if necessary
     */
    public NM getIvt24_RecommendedOrderPoint() { 
        NM ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-25: "Recommended Order Amount" - creates it if necessary
     */
    public NM getRecommendedOrderAmount() { 
        NM ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-25: "Recommended Order Amount" - creates it if necessary
     */
    public NM getIvt25_RecommendedOrderAmount() { 
        NM ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IVT-26: "Operating Room Par Level Indicator" - creates it if necessary
     */
    public CNE getOperatingRoomParLevelIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IVT-26: "Operating Room Par Level Indicator" - creates it if necessary
     */
    public CNE getIvt26_OperatingRoomParLevelIndicator() { 
        CNE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new EI(getMessage());
          case 2: return new ST(getMessage());
          case 3: return new EI(getMessage());
          case 4: return new ST(getMessage());
          case 5: return new CWE(getMessage());
          case 6: return new EI(getMessage());
          case 7: return new CWE(getMessage());
          case 8: return new CWE(getMessage());
          case 9: return new EI(getMessage());
          case 10: return new CNE(getMessage());
          case 11: return new CWE(getMessage());
          case 12: return new CP(getMessage());
          case 13: return new CWE(getMessage());
          case 14: return new CNE(getMessage());
          case 15: return new CNE(getMessage());
          case 16: return new CNE(getMessage());
          case 17: return new CP(getMessage());
          case 18: return new EI(getMessage());
          case 19: return new EI(getMessage());
          case 20: return new CWE(getMessage());
          case 21: return new NM(getMessage());
          case 22: return new NM(getMessage());
          case 23: return new NM(getMessage());
          case 24: return new NM(getMessage());
          case 25: return new CNE(getMessage());
          default: return null;
       }
   }


}

