/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 MFI message segment (Master File Identification). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>MFI-1: Master File Identifier (CWE) <b> </b>
     * <li>MFI-2: Master File Application Identifier (HD) <b>optional repeating</b>
     * <li>MFI-3: File-Level Event Code (ID) <b> </b>
     * <li>MFI-4: Entered Date/Time (DTM) <b>optional </b>
     * <li>MFI-5: Effective Date/Time (DTM) <b>optional </b>
     * <li>MFI-6: Response Level Code (ID) <b> </b>
 * </ul>
 */
public class MFI extends AbstractSegment {

    /** 
     * Creates a new MFI segment
     */
    public MFI(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CWE.class, true, 1, 250, new Object[]{ getMessage(), new Integer(175) }, "Master File Identifier");
                                  this.add(HD.class, false, 0, 180, new Object[]{ getMessage(), new Integer(361) }, "Master File Application Identifier");
                                  this.add(ID.class, true, 1, 3, new Object[]{ getMessage() }, "File-Level Event Code");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Entered Date/Time");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Effective Date/Time");
                                  this.add(ID.class, true, 1, 2, new Object[]{ getMessage() }, "Response Level Code");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFI - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * MFI-1: "Master File Identifier" - creates it if necessary
     */
    public CWE getMasterFileIdentifier() { 
        CWE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MFI-1: "Master File Identifier" - creates it if necessary
     */
    public CWE getMfi1_MasterFileIdentifier() { 
        CWE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Master File Application Identifier (MFI-2).
     */
    public HD[] getMasterFileApplicationIdentifier() {
        HD[] ret = null;
        try {
            Type[] t = this.getField(2);  
            ret = new HD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (HD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Master File Application Identifier (MFI-2).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getMasterFileApplicationIdentifierReps() {
        HD[] ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * MFI-2: "Master File Application Identifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public HD getMasterFileApplicationIdentifier(int rep) { 
        HD ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (HD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * MFI-2: "Master File Application Identifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public HD getMfi2_MasterFileApplicationIdentifier(int rep) { 
        HD ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (HD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Master File Application Identifier (MFI-2).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getMfi2_MasterFileApplicationIdentifierReps() {
        HD[] ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * MFI-2: "Master File Application Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public HD insertMasterFileApplicationIdentifier(int rep) throws HL7Exception { 
        return (HD) super.insertRepetition(2, rep);
    }



    /**
     * Inserts a repetition of
     * MFI-2: "Master File Application Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public HD insertMfi2_MasterFileApplicationIdentifier(int rep) throws HL7Exception { 
        return (HD) super.insertRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * MFI-2: "Master File Application Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public HD removeMasterFileApplicationIdentifier(int rep) throws HL7Exception { 
        return (HD) super.removeRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * MFI-2: "Master File Application Identifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public HD removeMfi2_MasterFileApplicationIdentifier(int rep) throws HL7Exception { 
        return (HD) super.removeRepetition(2, rep);
    }




    /**
     * Returns
     * MFI-3: "File-Level Event Code" - creates it if necessary
     */
    public ID getFileLevelEventCode() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MFI-3: "File-Level Event Code" - creates it if necessary
     */
    public ID getMfi3_FileLevelEventCode() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MFI-4: "Entered Date/Time" - creates it if necessary
     */
    public DTM getEnteredDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MFI-4: "Entered Date/Time" - creates it if necessary
     */
    public DTM getMfi4_EnteredDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MFI-5: "Effective Date/Time" - creates it if necessary
     */
    public DTM getEffectiveDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MFI-5: "Effective Date/Time" - creates it if necessary
     */
    public DTM getMfi5_EffectiveDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MFI-6: "Response Level Code" - creates it if necessary
     */
    public ID getResponseLevelCode() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MFI-6: "Response Level Code" - creates it if necessary
     */
    public ID getMfi6_ResponseLevelCode() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CWE(getMessage());
          case 1: return new HD(getMessage());
          case 2: return new ID(getMessage(), new Integer( 178 ));
          case 3: return new DTM(getMessage());
          case 4: return new DTM(getMessage());
          case 5: return new ID(getMessage(), new Integer( 179 ));
          default: return null;
       }
   }


}

