/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PCE message segment (Patient Charge Cost Center Exceptions). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PCE-1: Set ID - PCE (SI) <b> </b>
     * <li>PCE-2: Cost Center Account Number (IS) <b>optional </b>
     * <li>PCE-3: Transaction Code (CWE) <b>optional </b>
     * <li>PCE-4: Transaction amount - unit (CP) <b>optional </b>
 * </ul>
 */
public class PCE extends AbstractSegment {

    /** 
     * Creates a new PCE segment
     */
    public PCE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Set ID - PCE");
                                  this.add(IS.class, false, 1, 30, new Object[]{ getMessage() }, "Cost Center Account Number");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(132) }, "Transaction Code");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Transaction amount - unit");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PCE - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * PCE-1: "Set ID - PCE" - creates it if necessary
     */
    public SI getSetIDPCE() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PCE-1: "Set ID - PCE" - creates it if necessary
     */
    public SI getPce1_SetIDPCE() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PCE-2: "Cost Center Account Number" - creates it if necessary
     */
    public IS getCostCenterAccountNumber() { 
        IS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PCE-2: "Cost Center Account Number" - creates it if necessary
     */
    public IS getPce2_CostCenterAccountNumber() { 
        IS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PCE-3: "Transaction Code" - creates it if necessary
     */
    public CWE getTransactionCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PCE-3: "Transaction Code" - creates it if necessary
     */
    public CWE getPce3_TransactionCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PCE-4: "Transaction amount - unit" - creates it if necessary
     */
    public CP getTransactionAmountUnit() { 
        CP ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PCE-4: "Transaction amount - unit" - creates it if necessary
     */
    public CP getPce4_TransactionAmountUnit() { 
        CP ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new IS(getMessage(), new Integer( 319 ));
          case 2: return new CWE(getMessage());
          case 3: return new CP(getMessage());
          default: return null;
       }
   }


}

