/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PMT message segment (Payment Information). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PMT-1: Payment/Remittance Advice Number (EI) <b> </b>
     * <li>PMT-2: Payment/Remittance Effective Date/Time (DTM) <b> </b>
     * <li>PMT-3: Payment/Remittance Expiration Date/Time (DTM) <b> </b>
     * <li>PMT-4: Payment Method (CWE) <b> </b>
     * <li>PMT-5: Payment/Remittance Date/Time (DTM) <b> </b>
     * <li>PMT-6: Payment/Remittance Amount (CP) <b> </b>
     * <li>PMT-7: Check Number (EI) <b>optional </b>
     * <li>PMT-8: Payee Bank Identification (XON) <b>optional </b>
     * <li>PMT-9: Payee Transit Number (ST) <b>optional </b>
     * <li>PMT-10: Payee Bank Account ID (CX) <b>optional </b>
     * <li>PMT-11: Payment Organization (XON) <b> </b>
     * <li>PMT-12: ESR-Code-Line (ST) <b>optional </b>
 * </ul>
 */
public class PMT extends AbstractSegment {

    /** 
     * Creates a new PMT segment
     */
    public PMT(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(EI.class, true, 1, 73, new Object[]{ getMessage(), new Integer(0) }, "Payment/Remittance Advice Number");
                                  this.add(DTM.class, true, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Payment/Remittance Effective Date/Time");
                                  this.add(DTM.class, true, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Payment/Remittance Expiration Date/Time");
                                  this.add(CWE.class, true, 1, 177, new Object[]{ getMessage(), new Integer(570) }, "Payment Method");
                                  this.add(DTM.class, true, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Payment/Remittance Date/Time");
                                  this.add(CP.class, true, 1, 254, new Object[]{ getMessage(), new Integer(0) }, "Payment/Remittance Amount");
                                  this.add(EI.class, false, 1, 15, new Object[]{ getMessage(), new Integer(0) }, "Check Number");
                                  this.add(XON.class, false, 1, 6, new Object[]{ getMessage(), new Integer(0) }, "Payee Bank Identification");
                                  this.add(ST.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Payee Transit Number");
                                  this.add(CX.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Payee Bank Account ID");
                                  this.add(XON.class, true, 1, 183, new Object[]{ getMessage(), new Integer(0) }, "Payment Organization");
                                  this.add(ST.class, false, 1, 100, new Object[]{ getMessage(), new Integer(0) }, "ESR-Code-Line");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PMT - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * PMT-1: "Payment/Remittance Advice Number" - creates it if necessary
     */
    public EI getPaymentRemittanceAdviceNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PMT-1: "Payment/Remittance Advice Number" - creates it if necessary
     */
    public EI getPmt1_PaymentRemittanceAdviceNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PMT-2: "Payment/Remittance Effective Date/Time" - creates it if necessary
     */
    public DTM getPaymentRemittanceEffectiveDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PMT-2: "Payment/Remittance Effective Date/Time" - creates it if necessary
     */
    public DTM getPmt2_PaymentRemittanceEffectiveDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PMT-3: "Payment/Remittance Expiration Date/Time" - creates it if necessary
     */
    public DTM getPaymentRemittanceExpirationDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PMT-3: "Payment/Remittance Expiration Date/Time" - creates it if necessary
     */
    public DTM getPmt3_PaymentRemittanceExpirationDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PMT-4: "Payment Method" - creates it if necessary
     */
    public CWE getPaymentMethod() { 
        CWE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PMT-4: "Payment Method" - creates it if necessary
     */
    public CWE getPmt4_PaymentMethod() { 
        CWE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PMT-5: "Payment/Remittance Date/Time" - creates it if necessary
     */
    public DTM getPaymentRemittanceDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PMT-5: "Payment/Remittance Date/Time" - creates it if necessary
     */
    public DTM getPmt5_PaymentRemittanceDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PMT-6: "Payment/Remittance Amount" - creates it if necessary
     */
    public CP getPaymentRemittanceAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PMT-6: "Payment/Remittance Amount" - creates it if necessary
     */
    public CP getPmt6_PaymentRemittanceAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PMT-7: "Check Number" - creates it if necessary
     */
    public EI getCheckNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PMT-7: "Check Number" - creates it if necessary
     */
    public EI getPmt7_CheckNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PMT-8: "Payee Bank Identification" - creates it if necessary
     */
    public XON getPayeeBankIdentification() { 
        XON ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PMT-8: "Payee Bank Identification" - creates it if necessary
     */
    public XON getPmt8_PayeeBankIdentification() { 
        XON ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PMT-9: "Payee Transit Number" - creates it if necessary
     */
    public ST getPayeeTransitNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PMT-9: "Payee Transit Number" - creates it if necessary
     */
    public ST getPmt9_PayeeTransitNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PMT-10: "Payee Bank Account ID" - creates it if necessary
     */
    public CX getPayeeBankAccountID() { 
        CX ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PMT-10: "Payee Bank Account ID" - creates it if necessary
     */
    public CX getPmt10_PayeeBankAccountID() { 
        CX ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PMT-11: "Payment Organization" - creates it if necessary
     */
    public XON getPaymentOrganization() { 
        XON ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PMT-11: "Payment Organization" - creates it if necessary
     */
    public XON getPmt11_PaymentOrganization() { 
        XON ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PMT-12: "ESR-Code-Line" - creates it if necessary
     */
    public ST getESRCodeLine() { 
        ST ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PMT-12: "ESR-Code-Line" - creates it if necessary
     */
    public ST getPmt12_ESRCodeLine() { 
        ST ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new EI(getMessage());
          case 1: return new DTM(getMessage());
          case 2: return new DTM(getMessage());
          case 3: return new CWE(getMessage());
          case 4: return new DTM(getMessage());
          case 5: return new CP(getMessage());
          case 6: return new EI(getMessage());
          case 7: return new XON(getMessage());
          case 8: return new ST(getMessage());
          case 9: return new CX(getMessage());
          case 10: return new XON(getMessage());
          case 11: return new ST(getMessage());
          default: return null;
       }
   }


}

