/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PR1 message segment (Procedures). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PR1-1: Set ID - PR1 (SI) <b> </b>
     * <li>PR1-2: Procedure Coding Method (NULLDT) <b>optional </b>
     * <li>PR1-3: Procedure Code (CNE) <b> </b>
     * <li>PR1-4: Procedure Description (NULLDT) <b>optional </b>
     * <li>PR1-5: Procedure Date/Time (DTM) <b> </b>
     * <li>PR1-6: Procedure Functional Type (IS) <b>optional </b>
     * <li>PR1-7: Procedure Minutes (NM) <b>optional </b>
     * <li>PR1-8: Anesthesiologist (NULLDT) <b>optional </b>
     * <li>PR1-9: Anesthesia Code (IS) <b>optional </b>
     * <li>PR1-10: Anesthesia Minutes (NM) <b>optional </b>
     * <li>PR1-11: Surgeon (NULLDT) <b>optional </b>
     * <li>PR1-12: Procedure Practitioner (NULLDT) <b>optional </b>
     * <li>PR1-13: Consent Code (CWE) <b>optional </b>
     * <li>PR1-14: Procedure Priority (ID) <b>optional </b>
     * <li>PR1-15: Associated Diagnosis Code (CWE) <b>optional </b>
     * <li>PR1-16: Procedure Code Modifier (CNE) <b>optional repeating</b>
     * <li>PR1-17: Procedure DRG Type (IS) <b>optional </b>
     * <li>PR1-18: Tissue Type Code (CWE) <b>optional repeating</b>
     * <li>PR1-19: Procedure Identifier (EI) <b>optional </b>
     * <li>PR1-20: Procedure Action Code (ID) <b>optional </b>
     * <li>PR1-21: DRG Procedure Determination Status (IS) <b>optional </b>
     * <li>PR1-22: DRG Procedure Relevance (IS) <b>optional </b>
 * </ul>
 */
public class PR1 extends AbstractSegment {

    /** 
     * Creates a new PR1 segment
     */
    public PR1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID - PR1");
                                  this.add(NULLDT.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "Procedure Coding Method");
                                  this.add(CNE.class, true, 1, 705, new Object[]{ getMessage(), new Integer(88) }, "Procedure Code");
                                  this.add(NULLDT.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "Procedure Description");
                                  this.add(DTM.class, true, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Procedure Date/Time");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Procedure Functional Type");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Procedure Minutes");
                                  this.add(NULLDT.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "Anesthesiologist");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Anesthesia Code");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Anesthesia Minutes");
                                  this.add(NULLDT.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "Surgeon");
                                  this.add(NULLDT.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "Procedure Practitioner");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(59) }, "Consent Code");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Procedure Priority");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(51) }, "Associated Diagnosis Code");
                                  this.add(CNE.class, false, 0, 705, new Object[]{ getMessage(), new Integer(340) }, "Procedure Code Modifier");
                                  this.add(IS.class, false, 1, 20, new Object[]{ getMessage() }, "Procedure DRG Type");
                                  this.add(CWE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(417) }, "Tissue Type Code");
                                  this.add(EI.class, false, 1, 427, new Object[]{ getMessage(), new Integer(0) }, "Procedure Identifier");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Procedure Action Code");
                                  this.add(IS.class, false, 1, 20, new Object[]{ getMessage() }, "DRG Procedure Determination Status");
                                  this.add(IS.class, false, 1, 20, new Object[]{ getMessage() }, "DRG Procedure Relevance");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PR1 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * PR1-1: "Set ID - PR1" - creates it if necessary
     */
    public SI getSetIDPR1() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-1: "Set ID - PR1" - creates it if necessary
     */
    public SI getPr11_SetIDPR1() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-2: "Procedure Coding Method" - creates it if necessary
     */
    public NULLDT getProcedureCodingMethod() { 
        NULLDT ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (NULLDT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-2: "Procedure Coding Method" - creates it if necessary
     */
    public NULLDT getPr12_ProcedureCodingMethod() { 
        NULLDT ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (NULLDT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-3: "Procedure Code" - creates it if necessary
     */
    public CNE getProcedureCode() { 
        CNE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-3: "Procedure Code" - creates it if necessary
     */
    public CNE getPr13_ProcedureCode() { 
        CNE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-4: "Procedure Description" - creates it if necessary
     */
    public NULLDT getProcedureDescription() { 
        NULLDT ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NULLDT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-4: "Procedure Description" - creates it if necessary
     */
    public NULLDT getPr14_ProcedureDescription() { 
        NULLDT ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NULLDT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-5: "Procedure Date/Time" - creates it if necessary
     */
    public DTM getProcedureDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-5: "Procedure Date/Time" - creates it if necessary
     */
    public DTM getPr15_ProcedureDateTime() { 
        DTM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-6: "Procedure Functional Type" - creates it if necessary
     */
    public IS getProcedureFunctionalType() { 
        IS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-6: "Procedure Functional Type" - creates it if necessary
     */
    public IS getPr16_ProcedureFunctionalType() { 
        IS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-7: "Procedure Minutes" - creates it if necessary
     */
    public NM getProcedureMinutes() { 
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-7: "Procedure Minutes" - creates it if necessary
     */
    public NM getPr17_ProcedureMinutes() { 
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-8: "Anesthesiologist" - creates it if necessary
     */
    public NULLDT getAnesthesiologist() { 
        NULLDT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NULLDT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-8: "Anesthesiologist" - creates it if necessary
     */
    public NULLDT getPr18_Anesthesiologist() { 
        NULLDT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NULLDT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-9: "Anesthesia Code" - creates it if necessary
     */
    public IS getAnesthesiaCode() { 
        IS ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-9: "Anesthesia Code" - creates it if necessary
     */
    public IS getPr19_AnesthesiaCode() { 
        IS ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-10: "Anesthesia Minutes" - creates it if necessary
     */
    public NM getAnesthesiaMinutes() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-10: "Anesthesia Minutes" - creates it if necessary
     */
    public NM getPr110_AnesthesiaMinutes() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-11: "Surgeon" - creates it if necessary
     */
    public NULLDT getSurgeon() { 
        NULLDT ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (NULLDT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-11: "Surgeon" - creates it if necessary
     */
    public NULLDT getPr111_Surgeon() { 
        NULLDT ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (NULLDT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-12: "Procedure Practitioner" - creates it if necessary
     */
    public NULLDT getProcedurePractitioner() { 
        NULLDT ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NULLDT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-12: "Procedure Practitioner" - creates it if necessary
     */
    public NULLDT getPr112_ProcedurePractitioner() { 
        NULLDT ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NULLDT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-13: "Consent Code" - creates it if necessary
     */
    public CWE getConsentCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-13: "Consent Code" - creates it if necessary
     */
    public CWE getPr113_ConsentCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-14: "Procedure Priority" - creates it if necessary
     */
    public ID getProcedurePriority() { 
        ID ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-14: "Procedure Priority" - creates it if necessary
     */
    public ID getPr114_ProcedurePriority() { 
        ID ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-15: "Associated Diagnosis Code" - creates it if necessary
     */
    public CWE getAssociatedDiagnosisCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-15: "Associated Diagnosis Code" - creates it if necessary
     */
    public CWE getPr115_AssociatedDiagnosisCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Procedure Code Modifier (PR1-16).
     */
    public CNE[] getProcedureCodeModifier() {
        CNE[] ret = null;
        try {
            Type[] t = this.getField(16);  
            ret = new CNE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CNE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Procedure Code Modifier (PR1-16).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getProcedureCodeModifierReps() {
        CNE[] ret = null;
        try {
            Type[] t = this.getField(16);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * PR1-16: "Procedure Code Modifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CNE getProcedureCodeModifier(int rep) { 
        CNE ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PR1-16: "Procedure Code Modifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CNE getPr116_ProcedureCodeModifier(int rep) { 
        CNE ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Procedure Code Modifier (PR1-16).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getPr116_ProcedureCodeModifierReps() {
        CNE[] ret = null;
        try {
            Type[] t = this.getField(16);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * PR1-16: "Procedure Code Modifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CNE insertProcedureCodeModifier(int rep) throws HL7Exception { 
        return (CNE) super.insertRepetition(16, rep);
    }



    /**
     * Inserts a repetition of
     * PR1-16: "Procedure Code Modifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CNE insertPr116_ProcedureCodeModifier(int rep) throws HL7Exception { 
        return (CNE) super.insertRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * PR1-16: "Procedure Code Modifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CNE removeProcedureCodeModifier(int rep) throws HL7Exception { 
        return (CNE) super.removeRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * PR1-16: "Procedure Code Modifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CNE removePr116_ProcedureCodeModifier(int rep) throws HL7Exception { 
        return (CNE) super.removeRepetition(16, rep);
    }




    /**
     * Returns
     * PR1-17: "Procedure DRG Type" - creates it if necessary
     */
    public IS getProcedureDRGType() { 
        IS ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-17: "Procedure DRG Type" - creates it if necessary
     */
    public IS getPr117_ProcedureDRGType() { 
        IS ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Tissue Type Code (PR1-18).
     */
    public CWE[] getTissueTypeCode() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(18);  
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CWE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Tissue Type Code (PR1-18).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getTissueTypeCodeReps() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(18);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * PR1-18: "Tissue Type Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getTissueTypeCode(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PR1-18: "Tissue Type Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CWE getPr118_TissueTypeCode(int rep) { 
        CWE ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Tissue Type Code (PR1-18).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getPr118_TissueTypeCodeReps() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(18);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * PR1-18: "Tissue Type Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertTissueTypeCode(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(18, rep);
    }



    /**
     * Inserts a repetition of
     * PR1-18: "Tissue Type Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE insertPr118_TissueTypeCode(int rep) throws HL7Exception { 
        return (CWE) super.insertRepetition(18, rep);
    }


    /**
     * Removes a repetition of
     * PR1-18: "Tissue Type Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removeTissueTypeCode(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(18, rep);
    }


    /**
     * Removes a repetition of
     * PR1-18: "Tissue Type Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CWE removePr118_TissueTypeCode(int rep) throws HL7Exception { 
        return (CWE) super.removeRepetition(18, rep);
    }




    /**
     * Returns
     * PR1-19: "Procedure Identifier" - creates it if necessary
     */
    public EI getProcedureIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-19: "Procedure Identifier" - creates it if necessary
     */
    public EI getPr119_ProcedureIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-20: "Procedure Action Code" - creates it if necessary
     */
    public ID getProcedureActionCode() { 
        ID ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-20: "Procedure Action Code" - creates it if necessary
     */
    public ID getPr120_ProcedureActionCode() { 
        ID ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-21: "DRG Procedure Determination Status" - creates it if necessary
     */
    public IS getDRGProcedureDeterminationStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-21: "DRG Procedure Determination Status" - creates it if necessary
     */
    public IS getPr121_DRGProcedureDeterminationStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-22: "DRG Procedure Relevance" - creates it if necessary
     */
    public IS getDRGProcedureRelevance() { 
        IS ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-22: "DRG Procedure Relevance" - creates it if necessary
     */
    public IS getPr122_DRGProcedureRelevance() { 
        IS ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new NULLDT(getMessage());
          case 2: return new CNE(getMessage());
          case 3: return new NULLDT(getMessage());
          case 4: return new DTM(getMessage());
          case 5: return new IS(getMessage(), new Integer( 230 ));
          case 6: return new NM(getMessage());
          case 7: return new NULLDT(getMessage());
          case 8: return new IS(getMessage(), new Integer( 19 ));
          case 9: return new NM(getMessage());
          case 10: return new NULLDT(getMessage());
          case 11: return new NULLDT(getMessage());
          case 12: return new CWE(getMessage());
          case 13: return new ID(getMessage(), new Integer( 418 ));
          case 14: return new CWE(getMessage());
          case 15: return new CNE(getMessage());
          case 16: return new IS(getMessage(), new Integer( 416 ));
          case 17: return new CWE(getMessage());
          case 18: return new EI(getMessage());
          case 19: return new ID(getMessage(), new Integer( 206 ));
          case 20: return new IS(getMessage(), new Integer( 761 ));
          case 21: return new IS(getMessage(), new Integer( 763 ));
          default: return null;
       }
   }


}

