/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PSL message segment (Product/Service Line Item). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PSL-1: Provider Product/Service Line Item Number (EI) <b> </b>
     * <li>PSL-2: Payer Product/Service Line Item Number (EI) <b>optional </b>
     * <li>PSL-3: Product/Service Line Item Sequence Number (SI) <b> </b>
     * <li>PSL-4: Provider Tracking ID (EI) <b>optional </b>
     * <li>PSL-5: Payer Tracking ID (EI) <b>optional </b>
     * <li>PSL-6: Product/Service Line Item Status (CWE) <b> </b>
     * <li>PSL-7: Product/Service Code (CWE) <b> </b>
     * <li>PSL-8: Product/Service Code Modifier (CWE) <b>optional </b>
     * <li>PSL-9: Product/Service Code Description (ST) <b>optional </b>
     * <li>PSL-10: Product/Service Effective Date (DTM) <b>optional </b>
     * <li>PSL-11: Product/Service Expiration Date (DTM) <b>optional </b>
     * <li>PSL-12: Product/Service Quantity (CQ) <b>optional </b>
     * <li>PSL-13: Product/Service Unit Cost (CP) <b>optional </b>
     * <li>PSL-14: Number of Items per Unit (NM) <b>optional </b>
     * <li>PSL-15: Product/Service Gross Amount (CP) <b>optional </b>
     * <li>PSL-16: Product/Service Billed Amount (CP) <b>optional </b>
     * <li>PSL-17: Product/Service Clarification Code Type (IS) <b>optional </b>
     * <li>PSL-18: Product/Service Clarification Code Value (ST) <b>optional </b>
     * <li>PSL-19: Health Document Reference Identifier (EI) <b>optional </b>
     * <li>PSL-20: Processing Consideration Code (IS) <b>optional </b>
     * <li>PSL-21: Restricted Disclosure Indicator (ID) <b> </b>
     * <li>PSL-22: Related Product/Service Code Indicator (CWE) <b>optional </b>
     * <li>PSL-23: Product/Service Amount for Physician (CP) <b>optional </b>
     * <li>PSL-24: Product/Service Cost Factor (NM) <b>optional </b>
     * <li>PSL-25: Cost Center (CX) <b>optional </b>
     * <li>PSL-26: Billing Period (DR) <b>optional </b>
     * <li>PSL-27: Days without Billing (NM) <b>optional </b>
     * <li>PSL-28: Session-No (NM) <b>optional </b>
     * <li>PSL-29: Executing Physician ID (XCN) <b>optional </b>
     * <li>PSL-30: Responsible Physician ID (XCN) <b>optional </b>
     * <li>PSL-31: Role Executing Physician (CWE) <b>optional </b>
     * <li>PSL-32: Medical Role Executing Physician (CWE) <b>optional </b>
     * <li>PSL-33: Side of body (CWE) <b>optional </b>
     * <li>PSL-34: Number of TP's PP (NM) <b>optional </b>
     * <li>PSL-35: TP-Value PP (CP) <b>optional </b>
     * <li>PSL-36: Internal Scaling Factor PP (NM) <b>optional </b>
     * <li>PSL-37: External Scaling Factor PP (NM) <b>optional </b>
     * <li>PSL-38: Amount PP (CP) <b>optional </b>
     * <li>PSL-39: Number of TP's Technical Part (NM) <b>optional </b>
     * <li>PSL-40: TP-Value Technical Part (CP) <b>optional </b>
     * <li>PSL-41: Internal Scaling Factor Technical Part (NM) <b>optional </b>
     * <li>PSL-42: External Scaling Factor Technical Part (NM) <b>optional </b>
     * <li>PSL-43: Amount Technical Part (CP) <b>optional </b>
     * <li>PSL-44: Total Amount Professional Part + Technical Part (CP) <b>optional </b>
     * <li>PSL-45: VAT-Rate (NM) <b>optional </b>
     * <li>PSL-46: Main-Service (ID) <b>optional </b>
     * <li>PSL-47: Validation (ID) <b>optional </b>
     * <li>PSL-48: Comment (ST) <b>optional </b>
 * </ul>
 */
public class PSL extends AbstractSegment {

    /** 
     * Creates a new PSL segment
     */
    public PSL(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(EI.class, true, 1, 73, new Object[]{ getMessage(), new Integer(0) }, "Provider Product/Service Line Item Number");
                                  this.add(EI.class, false, 1, 73, new Object[]{ getMessage(), new Integer(0) }, "Payer Product/Service Line Item Number");
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Product/Service Line Item Sequence Number");
                                  this.add(EI.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Provider Tracking ID");
                                  this.add(EI.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Payer Tracking ID");
                                  this.add(CWE.class, true, 1, 2, new Object[]{ getMessage(), new Integer(559) }, "Product/Service Line Item Status");
                                  this.add(CWE.class, true, 1, 177, new Object[]{ getMessage(), new Integer(879) }, "Product/Service Code");
                                  this.add(CWE.class, false, 1, 177, new Object[]{ getMessage(), new Integer(880) }, "Product/Service Code Modifier");
                                  this.add(ST.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Product/Service Code Description");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Product/Service Effective Date");
                                  this.add(DTM.class, false, 1, 24, new Object[]{ getMessage(), new Integer(0) }, "Product/Service Expiration Date");
                                  this.add(CQ.class, false, 1, 222, new Object[]{ getMessage(), new Integer(560) }, "Product/Service Quantity");
                                  this.add(CP.class, false, 1, 254, new Object[]{ getMessage(), new Integer(0) }, "Product/Service Unit Cost");
                                  this.add(NM.class, false, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "Number of Items per Unit");
                                  this.add(CP.class, false, 1, 254, new Object[]{ getMessage(), new Integer(0) }, "Product/Service Gross Amount");
                                  this.add(CP.class, false, 1, 254, new Object[]{ getMessage(), new Integer(0) }, "Product/Service Billed Amount");
                                  this.add(IS.class, false, 1, 10, new Object[]{ getMessage() }, "Product/Service Clarification Code Type");
                                  this.add(ST.class, false, 1, 40, new Object[]{ getMessage(), new Integer(0) }, "Product/Service Clarification Code Value");
                                  this.add(EI.class, false, 1, 73, new Object[]{ getMessage(), new Integer(0) }, "Health Document Reference Identifier");
                                  this.add(IS.class, false, 1, 10, new Object[]{ getMessage() }, "Processing Consideration Code");
                                  this.add(ID.class, true, 1, 2, new Object[]{ getMessage() }, "Restricted Disclosure Indicator");
                                  this.add(CWE.class, false, 1, 177, new Object[]{ getMessage(), new Integer(879) }, "Related Product/Service Code Indicator");
                                  this.add(CP.class, false, 1, 254, new Object[]{ getMessage(), new Integer(0) }, "Product/Service Amount for Physician");
                                  this.add(NM.class, false, 1, 5, new Object[]{ getMessage(), new Integer(0) }, "Product/Service Cost Factor");
                                  this.add(CX.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Cost Center");
                                  this.add(DR.class, false, 1, 49, new Object[]{ getMessage(), new Integer(0) }, "Billing Period");
                                  this.add(NM.class, false, 1, 5, new Object[]{ getMessage(), new Integer(0) }, "Days without Billing");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Session-No");
                                  this.add(XCN.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Executing Physician ID");
                                  this.add(XCN.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Responsible Physician ID");
                                  this.add(CWE.class, false, 1, 10, new Object[]{ getMessage(), new Integer(881) }, "Role Executing Physician");
                                  this.add(CWE.class, false, 1, 10, new Object[]{ getMessage(), new Integer(882) }, "Medical Role Executing Physician");
                                  this.add(CWE.class, false, 1, 3, new Object[]{ getMessage(), new Integer(894) }, "Side of body");
                                  this.add(NM.class, false, 1, 6, new Object[]{ getMessage(), new Integer(0) }, "Number of TP's PP");
                                  this.add(CP.class, false, 1, 6, new Object[]{ getMessage(), new Integer(0) }, "TP-Value PP");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Internal Scaling Factor PP");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "External Scaling Factor PP");
                                  this.add(CP.class, false, 1, 7, new Object[]{ getMessage(), new Integer(0) }, "Amount PP");
                                  this.add(NM.class, false, 1, 6, new Object[]{ getMessage(), new Integer(0) }, "Number of TP's Technical Part");
                                  this.add(CP.class, false, 1, 6, new Object[]{ getMessage(), new Integer(0) }, "TP-Value Technical Part");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Internal Scaling Factor Technical Part");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "External Scaling Factor Technical Part");
                                  this.add(CP.class, false, 1, 7, new Object[]{ getMessage(), new Integer(0) }, "Amount Technical Part");
                                  this.add(CP.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Total Amount Professional Part + Technical Part");
                                  this.add(NM.class, false, 1, 3, new Object[]{ getMessage(), new Integer(0) }, "VAT-Rate");
                                  this.add(ID.class, false, 1, 20, new Object[]{ getMessage() }, "Main-Service");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Validation");
                                  this.add(ST.class, false, 1, 255, new Object[]{ getMessage(), new Integer(0) }, "Comment");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PSL - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * PSL-1: "Provider Product/Service Line Item Number" - creates it if necessary
     */
    public EI getProviderProductServiceLineItemNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-1: "Provider Product/Service Line Item Number" - creates it if necessary
     */
    public EI getPsl1_ProviderProductServiceLineItemNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-2: "Payer Product/Service Line Item Number" - creates it if necessary
     */
    public EI getPayerProductServiceLineItemNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-2: "Payer Product/Service Line Item Number" - creates it if necessary
     */
    public EI getPsl2_PayerProductServiceLineItemNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-3: "Product/Service Line Item Sequence Number" - creates it if necessary
     */
    public SI getProductServiceLineItemSequenceNumber() { 
        SI ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-3: "Product/Service Line Item Sequence Number" - creates it if necessary
     */
    public SI getPsl3_ProductServiceLineItemSequenceNumber() { 
        SI ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-4: "Provider Tracking ID" - creates it if necessary
     */
    public EI getProviderTrackingID() { 
        EI ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-4: "Provider Tracking ID" - creates it if necessary
     */
    public EI getPsl4_ProviderTrackingID() { 
        EI ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-5: "Payer Tracking ID" - creates it if necessary
     */
    public EI getPayerTrackingID() { 
        EI ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-5: "Payer Tracking ID" - creates it if necessary
     */
    public EI getPsl5_PayerTrackingID() { 
        EI ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-6: "Product/Service Line Item Status" - creates it if necessary
     */
    public CWE getProductServiceLineItemStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-6: "Product/Service Line Item Status" - creates it if necessary
     */
    public CWE getPsl6_ProductServiceLineItemStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-7: "Product/Service Code" - creates it if necessary
     */
    public CWE getProductServiceCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-7: "Product/Service Code" - creates it if necessary
     */
    public CWE getPsl7_ProductServiceCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-8: "Product/Service Code Modifier" - creates it if necessary
     */
    public CWE getProductServiceCodeModifier() { 
        CWE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-8: "Product/Service Code Modifier" - creates it if necessary
     */
    public CWE getPsl8_ProductServiceCodeModifier() { 
        CWE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-9: "Product/Service Code Description" - creates it if necessary
     */
    public ST getProductServiceCodeDescription() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-9: "Product/Service Code Description" - creates it if necessary
     */
    public ST getPsl9_ProductServiceCodeDescription() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-10: "Product/Service Effective Date" - creates it if necessary
     */
    public DTM getProductServiceEffectiveDate() { 
        DTM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-10: "Product/Service Effective Date" - creates it if necessary
     */
    public DTM getPsl10_ProductServiceEffectiveDate() { 
        DTM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-11: "Product/Service Expiration Date" - creates it if necessary
     */
    public DTM getProductServiceExpirationDate() { 
        DTM ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-11: "Product/Service Expiration Date" - creates it if necessary
     */
    public DTM getPsl11_ProductServiceExpirationDate() { 
        DTM ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (DTM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-12: "Product/Service Quantity" - creates it if necessary
     */
    public CQ getProductServiceQuantity() { 
        CQ ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-12: "Product/Service Quantity" - creates it if necessary
     */
    public CQ getPsl12_ProductServiceQuantity() { 
        CQ ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-13: "Product/Service Unit Cost" - creates it if necessary
     */
    public CP getProductServiceUnitCost() { 
        CP ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-13: "Product/Service Unit Cost" - creates it if necessary
     */
    public CP getPsl13_ProductServiceUnitCost() { 
        CP ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-14: "Number of Items per Unit" - creates it if necessary
     */
    public NM getNumberOfItemsPerUnit() { 
        NM ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-14: "Number of Items per Unit" - creates it if necessary
     */
    public NM getPsl14_NumberOfItemsPerUnit() { 
        NM ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-15: "Product/Service Gross Amount" - creates it if necessary
     */
    public CP getProductServiceGrossAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-15: "Product/Service Gross Amount" - creates it if necessary
     */
    public CP getPsl15_ProductServiceGrossAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-16: "Product/Service Billed Amount" - creates it if necessary
     */
    public CP getProductServiceBilledAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-16: "Product/Service Billed Amount" - creates it if necessary
     */
    public CP getPsl16_ProductServiceBilledAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-17: "Product/Service Clarification Code Type" - creates it if necessary
     */
    public IS getProductServiceClarificationCodeType() { 
        IS ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-17: "Product/Service Clarification Code Type" - creates it if necessary
     */
    public IS getPsl17_ProductServiceClarificationCodeType() { 
        IS ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-18: "Product/Service Clarification Code Value" - creates it if necessary
     */
    public ST getProductServiceClarificationCodeValue() { 
        ST ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-18: "Product/Service Clarification Code Value" - creates it if necessary
     */
    public ST getPsl18_ProductServiceClarificationCodeValue() { 
        ST ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-19: "Health Document Reference Identifier" - creates it if necessary
     */
    public EI getHealthDocumentReferenceIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-19: "Health Document Reference Identifier" - creates it if necessary
     */
    public EI getPsl19_HealthDocumentReferenceIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-20: "Processing Consideration Code" - creates it if necessary
     */
    public IS getProcessingConsiderationCode() { 
        IS ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-20: "Processing Consideration Code" - creates it if necessary
     */
    public IS getPsl20_ProcessingConsiderationCode() { 
        IS ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-21: "Restricted Disclosure Indicator" - creates it if necessary
     */
    public ID getRestrictedDisclosureIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-21: "Restricted Disclosure Indicator" - creates it if necessary
     */
    public ID getPsl21_RestrictedDisclosureIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-22: "Related Product/Service Code Indicator" - creates it if necessary
     */
    public CWE getRelatedProductServiceCodeIndicator() { 
        CWE ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-22: "Related Product/Service Code Indicator" - creates it if necessary
     */
    public CWE getPsl22_RelatedProductServiceCodeIndicator() { 
        CWE ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-23: "Product/Service Amount for Physician" - creates it if necessary
     */
    public CP getProductServiceAmountForPhysician() { 
        CP ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-23: "Product/Service Amount for Physician" - creates it if necessary
     */
    public CP getPsl23_ProductServiceAmountForPhysician() { 
        CP ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-24: "Product/Service Cost Factor" - creates it if necessary
     */
    public NM getProductServiceCostFactor() { 
        NM ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-24: "Product/Service Cost Factor" - creates it if necessary
     */
    public NM getPsl24_ProductServiceCostFactor() { 
        NM ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-25: "Cost Center" - creates it if necessary
     */
    public CX getCostCenter() { 
        CX ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-25: "Cost Center" - creates it if necessary
     */
    public CX getPsl25_CostCenter() { 
        CX ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-26: "Billing Period" - creates it if necessary
     */
    public DR getBillingPeriod() { 
        DR ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (DR)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-26: "Billing Period" - creates it if necessary
     */
    public DR getPsl26_BillingPeriod() { 
        DR ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (DR)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-27: "Days without Billing" - creates it if necessary
     */
    public NM getDaysWithoutBilling() { 
        NM ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-27: "Days without Billing" - creates it if necessary
     */
    public NM getPsl27_DaysWithoutBilling() { 
        NM ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-28: "Session-No" - creates it if necessary
     */
    public NM getSessionNo() { 
        NM ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-28: "Session-No" - creates it if necessary
     */
    public NM getPsl28_SessionNo() { 
        NM ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-29: "Executing Physician ID" - creates it if necessary
     */
    public XCN getExecutingPhysicianID() { 
        XCN ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-29: "Executing Physician ID" - creates it if necessary
     */
    public XCN getPsl29_ExecutingPhysicianID() { 
        XCN ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-30: "Responsible Physician ID" - creates it if necessary
     */
    public XCN getResponsiblePhysicianID() { 
        XCN ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-30: "Responsible Physician ID" - creates it if necessary
     */
    public XCN getPsl30_ResponsiblePhysicianID() { 
        XCN ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-31: "Role Executing Physician" - creates it if necessary
     */
    public CWE getRoleExecutingPhysician() { 
        CWE ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-31: "Role Executing Physician" - creates it if necessary
     */
    public CWE getPsl31_RoleExecutingPhysician() { 
        CWE ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-32: "Medical Role Executing Physician" - creates it if necessary
     */
    public CWE getMedicalRoleExecutingPhysician() { 
        CWE ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-32: "Medical Role Executing Physician" - creates it if necessary
     */
    public CWE getPsl32_MedicalRoleExecutingPhysician() { 
        CWE ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-33: "Side of body" - creates it if necessary
     */
    public CWE getSideOfBody() { 
        CWE ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-33: "Side of body" - creates it if necessary
     */
    public CWE getPsl33_SideOfBody() { 
        CWE ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-34: "Number of TP's PP" - creates it if necessary
     */
    public NM getNumberOfTPSPP() { 
        NM ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-34: "Number of TP's PP" - creates it if necessary
     */
    public NM getPsl34_NumberOfTPSPP() { 
        NM ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-35: "TP-Value PP" - creates it if necessary
     */
    public CP getTPValuePP() { 
        CP ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-35: "TP-Value PP" - creates it if necessary
     */
    public CP getPsl35_TPValuePP() { 
        CP ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-36: "Internal Scaling Factor PP" - creates it if necessary
     */
    public NM getInternalScalingFactorPP() { 
        NM ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-36: "Internal Scaling Factor PP" - creates it if necessary
     */
    public NM getPsl36_InternalScalingFactorPP() { 
        NM ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-37: "External Scaling Factor PP" - creates it if necessary
     */
    public NM getExternalScalingFactorPP() { 
        NM ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-37: "External Scaling Factor PP" - creates it if necessary
     */
    public NM getPsl37_ExternalScalingFactorPP() { 
        NM ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-38: "Amount PP" - creates it if necessary
     */
    public CP getAmountPP() { 
        CP ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-38: "Amount PP" - creates it if necessary
     */
    public CP getPsl38_AmountPP() { 
        CP ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-39: "Number of TP's Technical Part" - creates it if necessary
     */
    public NM getNumberOfTPSTechnicalPart() { 
        NM ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-39: "Number of TP's Technical Part" - creates it if necessary
     */
    public NM getPsl39_NumberOfTPSTechnicalPart() { 
        NM ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-40: "TP-Value Technical Part" - creates it if necessary
     */
    public CP getTPValueTechnicalPart() { 
        CP ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-40: "TP-Value Technical Part" - creates it if necessary
     */
    public CP getPsl40_TPValueTechnicalPart() { 
        CP ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-41: "Internal Scaling Factor Technical Part" - creates it if necessary
     */
    public NM getInternalScalingFactorTechnicalPart() { 
        NM ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-41: "Internal Scaling Factor Technical Part" - creates it if necessary
     */
    public NM getPsl41_InternalScalingFactorTechnicalPart() { 
        NM ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-42: "External Scaling Factor Technical Part" - creates it if necessary
     */
    public NM getExternalScalingFactorTechnicalPart() { 
        NM ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-42: "External Scaling Factor Technical Part" - creates it if necessary
     */
    public NM getPsl42_ExternalScalingFactorTechnicalPart() { 
        NM ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-43: "Amount Technical Part" - creates it if necessary
     */
    public CP getAmountTechnicalPart() { 
        CP ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-43: "Amount Technical Part" - creates it if necessary
     */
    public CP getPsl43_AmountTechnicalPart() { 
        CP ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-44: "Total Amount Professional Part + Technical Part" - creates it if necessary
     */
    public CP getTotalAmountProfessionalPartTechnicalPart() { 
        CP ret = null;
        try {
            Type t = this.getField(44, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-44: "Total Amount Professional Part + Technical Part" - creates it if necessary
     */
    public CP getPsl44_TotalAmountProfessionalPartTechnicalPart() { 
        CP ret = null;
        try {
            Type t = this.getField(44, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-45: "VAT-Rate" - creates it if necessary
     */
    public NM getVATRate() { 
        NM ret = null;
        try {
            Type t = this.getField(45, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-45: "VAT-Rate" - creates it if necessary
     */
    public NM getPsl45_VATRate() { 
        NM ret = null;
        try {
            Type t = this.getField(45, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-46: "Main-Service" - creates it if necessary
     */
    public ID getMainService() { 
        ID ret = null;
        try {
            Type t = this.getField(46, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-46: "Main-Service" - creates it if necessary
     */
    public ID getPsl46_MainService() { 
        ID ret = null;
        try {
            Type t = this.getField(46, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-47: "Validation" - creates it if necessary
     */
    public ID getValidation() { 
        ID ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-47: "Validation" - creates it if necessary
     */
    public ID getPsl47_Validation() { 
        ID ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PSL-48: "Comment" - creates it if necessary
     */
    public ST getComment() { 
        ST ret = null;
        try {
            Type t = this.getField(48, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PSL-48: "Comment" - creates it if necessary
     */
    public ST getPsl48_Comment() { 
        ST ret = null;
        try {
            Type t = this.getField(48, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new EI(getMessage());
          case 1: return new EI(getMessage());
          case 2: return new SI(getMessage());
          case 3: return new EI(getMessage());
          case 4: return new EI(getMessage());
          case 5: return new CWE(getMessage());
          case 6: return new CWE(getMessage());
          case 7: return new CWE(getMessage());
          case 8: return new ST(getMessage());
          case 9: return new DTM(getMessage());
          case 10: return new DTM(getMessage());
          case 11: return new CQ(getMessage());
          case 12: return new CP(getMessage());
          case 13: return new NM(getMessage());
          case 14: return new CP(getMessage());
          case 15: return new CP(getMessage());
          case 16: return new IS(getMessage(), new Integer( 561 ));
          case 17: return new ST(getMessage());
          case 18: return new EI(getMessage());
          case 19: return new IS(getMessage(), new Integer( 562 ));
          case 20: return new ID(getMessage(), new Integer( 532 ));
          case 21: return new CWE(getMessage());
          case 22: return new CP(getMessage());
          case 23: return new NM(getMessage());
          case 24: return new CX(getMessage());
          case 25: return new DR(getMessage());
          case 26: return new NM(getMessage());
          case 27: return new NM(getMessage());
          case 28: return new XCN(getMessage());
          case 29: return new XCN(getMessage());
          case 30: return new CWE(getMessage());
          case 31: return new CWE(getMessage());
          case 32: return new CWE(getMessage());
          case 33: return new NM(getMessage());
          case 34: return new CP(getMessage());
          case 35: return new NM(getMessage());
          case 36: return new NM(getMessage());
          case 37: return new CP(getMessage());
          case 38: return new NM(getMessage());
          case 39: return new CP(getMessage());
          case 40: return new NM(getMessage());
          case 41: return new NM(getMessage());
          case 42: return new CP(getMessage());
          case 43: return new CP(getMessage());
          case 44: return new NM(getMessage());
          case 45: return new ID(getMessage(), new Integer( 0 ));
          case 46: return new ID(getMessage(), new Integer( 136 ));
          case 47: return new ST(getMessage());
          default: return null;
       }
   }


}

