/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PYE message segment (Payee Information). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PYE-1: Set ID - PYE (SI) <b> </b>
     * <li>PYE-2: Payee Type (IS) <b> </b>
     * <li>PYE-3: Payee Relationship to Invoice (Patient) (IS) <b>optional </b>
     * <li>PYE-4: Payee Identification List (XON) <b>optional </b>
     * <li>PYE-5: Payee Person Name (XPN) <b>optional </b>
     * <li>PYE-6: Payee Address (XAD) <b>optional </b>
     * <li>PYE-7: Payment Method (IS) <b>optional </b>
 * </ul>
 */
public class PYE extends AbstractSegment {

    /** 
     * Creates a new PYE segment
     */
    public PYE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID - PYE");
                                  this.add(IS.class, true, 1, 6, new Object[]{ getMessage() }, "Payee Type");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Payee Relationship to Invoice (Patient)");
                                  this.add(XON.class, false, 1, 183, new Object[]{ getMessage(), new Integer(0) }, "Payee Identification List");
                                  this.add(XPN.class, false, 1, 466, new Object[]{ getMessage(), new Integer(0) }, "Payee Person Name");
                                  this.add(XAD.class, false, 1, 235, new Object[]{ getMessage(), new Integer(0) }, "Payee Address");
                                  this.add(IS.class, false, 1, 80, new Object[]{ getMessage() }, "Payment Method");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PYE - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * PYE-1: "Set ID - PYE" - creates it if necessary
     */
    public SI getSetIDPYE() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PYE-1: "Set ID - PYE" - creates it if necessary
     */
    public SI getPye1_SetIDPYE() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PYE-2: "Payee Type" - creates it if necessary
     */
    public IS getPayeeType() { 
        IS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PYE-2: "Payee Type" - creates it if necessary
     */
    public IS getPye2_PayeeType() { 
        IS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PYE-3: "Payee Relationship to Invoice (Patient)" - creates it if necessary
     */
    public IS getPayeeRelationshipToInvoicePatient() { 
        IS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PYE-3: "Payee Relationship to Invoice (Patient)" - creates it if necessary
     */
    public IS getPye3_PayeeRelationshipToInvoicePatient() { 
        IS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PYE-4: "Payee Identification List" - creates it if necessary
     */
    public XON getPayeeIdentificationList() { 
        XON ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PYE-4: "Payee Identification List" - creates it if necessary
     */
    public XON getPye4_PayeeIdentificationList() { 
        XON ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PYE-5: "Payee Person Name" - creates it if necessary
     */
    public XPN getPayeePersonName() { 
        XPN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PYE-5: "Payee Person Name" - creates it if necessary
     */
    public XPN getPye5_PayeePersonName() { 
        XPN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PYE-6: "Payee Address" - creates it if necessary
     */
    public XAD getPayeeAddress() { 
        XAD ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PYE-6: "Payee Address" - creates it if necessary
     */
    public XAD getPye6_PayeeAddress() { 
        XAD ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PYE-7: "Payment Method" - creates it if necessary
     */
    public IS getPaymentMethod() { 
        IS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PYE-7: "Payment Method" - creates it if necessary
     */
    public IS getPye7_PaymentMethod() { 
        IS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new IS(getMessage(), new Integer( 557 ));
          case 2: return new IS(getMessage(), new Integer( 558 ));
          case 3: return new XON(getMessage());
          case 4: return new XPN(getMessage());
          case 5: return new XAD(getMessage());
          case 6: return new IS(getMessage(), new Integer( 570 ));
          default: return null;
       }
   }


}

