/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v26.segment;

// import ca.uhn.hl7v2.model.v26.group.*;
import ca.uhn.hl7v2.model.v26.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 TCC message segment (Test Code Configuration). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>TCC-1: Universal Service Identifier (CWE) <b> </b>
     * <li>TCC-2: Equipment Test Application Identifier (EI) <b> </b>
     * <li>TCC-3: Specimen Source (SPS) <b>optional </b>
     * <li>TCC-4: Auto-Dilution Factor Default (SN) <b>optional </b>
     * <li>TCC-5: Rerun Dilution Factor Default (SN) <b>optional </b>
     * <li>TCC-6: Pre-Dilution Factor Default (SN) <b>optional </b>
     * <li>TCC-7: Endogenous Content of Pre-Dilution Diluent (SN) <b>optional </b>
     * <li>TCC-8: Inventory Limits Warning Level (NM) <b>optional </b>
     * <li>TCC-9: Automatic Rerun Allowed (ID) <b>optional </b>
     * <li>TCC-10: Automatic Repeat Allowed (ID) <b>optional </b>
     * <li>TCC-11: Automatic Reflex Allowed (ID) <b>optional </b>
     * <li>TCC-12: Equipment Dynamic Range (SN) <b>optional </b>
     * <li>TCC-13: Units (CWE) <b>optional </b>
     * <li>TCC-14: Processing Type (CWE) <b>optional </b>
 * </ul>
 */
public class TCC extends AbstractSegment {

    /** 
     * Creates a new TCC segment
     */
    public TCC(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CWE.class, true, 1, 705, new Object[]{ getMessage(), new Integer(0) }, "Universal Service Identifier");
                                  this.add(EI.class, true, 1, 427, new Object[]{ getMessage(), new Integer(0) }, "Equipment Test Application Identifier");
                                  this.add(SPS.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "Specimen Source");
                                  this.add(SN.class, false, 1, 36, new Object[]{ getMessage(), new Integer(0) }, "Auto-Dilution Factor Default");
                                  this.add(SN.class, false, 1, 36, new Object[]{ getMessage(), new Integer(0) }, "Rerun Dilution Factor Default");
                                  this.add(SN.class, false, 1, 36, new Object[]{ getMessage(), new Integer(0) }, "Pre-Dilution Factor Default");
                                  this.add(SN.class, false, 1, 36, new Object[]{ getMessage(), new Integer(0) }, "Endogenous Content of Pre-Dilution Diluent");
                                  this.add(NM.class, false, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "Inventory Limits Warning Level");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Automatic Rerun Allowed");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Automatic Repeat Allowed");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Automatic Reflex Allowed");
                                  this.add(SN.class, false, 1, 36, new Object[]{ getMessage(), new Integer(0) }, "Equipment Dynamic Range");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(9999) }, "Units");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(388) }, "Processing Type");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating TCC - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * TCC-1: "Universal Service Identifier" - creates it if necessary
     */
    public CWE getUniversalServiceIdentifier() { 
        CWE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCC-1: "Universal Service Identifier" - creates it if necessary
     */
    public CWE getTcc1_UniversalServiceIdentifier() { 
        CWE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCC-2: "Equipment Test Application Identifier" - creates it if necessary
     */
    public EI getEquipmentTestApplicationIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCC-2: "Equipment Test Application Identifier" - creates it if necessary
     */
    public EI getTcc2_EquipmentTestApplicationIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCC-3: "Specimen Source" - creates it if necessary
     */
    public SPS getSpecimenSource() { 
        SPS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (SPS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCC-3: "Specimen Source" - creates it if necessary
     */
    public SPS getTcc3_SpecimenSource() { 
        SPS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (SPS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCC-4: "Auto-Dilution Factor Default" - creates it if necessary
     */
    public SN getAutoDilutionFactorDefault() { 
        SN ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCC-4: "Auto-Dilution Factor Default" - creates it if necessary
     */
    public SN getTcc4_AutoDilutionFactorDefault() { 
        SN ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCC-5: "Rerun Dilution Factor Default" - creates it if necessary
     */
    public SN getRerunDilutionFactorDefault() { 
        SN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCC-5: "Rerun Dilution Factor Default" - creates it if necessary
     */
    public SN getTcc5_RerunDilutionFactorDefault() { 
        SN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCC-6: "Pre-Dilution Factor Default" - creates it if necessary
     */
    public SN getPreDilutionFactorDefault() { 
        SN ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCC-6: "Pre-Dilution Factor Default" - creates it if necessary
     */
    public SN getTcc6_PreDilutionFactorDefault() { 
        SN ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCC-7: "Endogenous Content of Pre-Dilution Diluent" - creates it if necessary
     */
    public SN getEndogenousContentOfPreDilutionDiluent() { 
        SN ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCC-7: "Endogenous Content of Pre-Dilution Diluent" - creates it if necessary
     */
    public SN getTcc7_EndogenousContentOfPreDilutionDiluent() { 
        SN ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCC-8: "Inventory Limits Warning Level" - creates it if necessary
     */
    public NM getInventoryLimitsWarningLevel() { 
        NM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCC-8: "Inventory Limits Warning Level" - creates it if necessary
     */
    public NM getTcc8_InventoryLimitsWarningLevel() { 
        NM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCC-9: "Automatic Rerun Allowed" - creates it if necessary
     */
    public ID getAutomaticRerunAllowed() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCC-9: "Automatic Rerun Allowed" - creates it if necessary
     */
    public ID getTcc9_AutomaticRerunAllowed() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCC-10: "Automatic Repeat Allowed" - creates it if necessary
     */
    public ID getAutomaticRepeatAllowed() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCC-10: "Automatic Repeat Allowed" - creates it if necessary
     */
    public ID getTcc10_AutomaticRepeatAllowed() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCC-11: "Automatic Reflex Allowed" - creates it if necessary
     */
    public ID getAutomaticReflexAllowed() { 
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCC-11: "Automatic Reflex Allowed" - creates it if necessary
     */
    public ID getTcc11_AutomaticReflexAllowed() { 
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCC-12: "Equipment Dynamic Range" - creates it if necessary
     */
    public SN getEquipmentDynamicRange() { 
        SN ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCC-12: "Equipment Dynamic Range" - creates it if necessary
     */
    public SN getTcc12_EquipmentDynamicRange() { 
        SN ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (SN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCC-13: "Units" - creates it if necessary
     */
    public CWE getUnits() { 
        CWE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCC-13: "Units" - creates it if necessary
     */
    public CWE getTcc13_Units() { 
        CWE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TCC-14: "Processing Type" - creates it if necessary
     */
    public CWE getProcessingType() { 
        CWE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TCC-14: "Processing Type" - creates it if necessary
     */
    public CWE getTcc14_ProcessingType() { 
        CWE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CWE(getMessage());
          case 1: return new EI(getMessage());
          case 2: return new SPS(getMessage());
          case 3: return new SN(getMessage());
          case 4: return new SN(getMessage());
          case 5: return new SN(getMessage());
          case 6: return new SN(getMessage());
          case 7: return new NM(getMessage());
          case 8: return new ID(getMessage(), new Integer( 136 ));
          case 9: return new ID(getMessage(), new Integer( 136 ));
          case 10: return new ID(getMessage(), new Integer( 136 ));
          case 11: return new SN(getMessage());
          case 12: return new CWE(getMessage());
          case 13: return new CWE(getMessage());
          default: return null;
       }
   }


}

