/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.EHC_E21_PSL_ITEM_INFO;
import ca.uhn.hl7v2.model.v26.segment.IVC;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class EHC_E21
extends AbstractMessage {
    public EHC_E21() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public EHC_E21(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, true);
            this.add(IVC.class, true, false);
            this.add(EHC_E21_PSL_ITEM_INFO.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating EHC_E21 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT() {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT(int rep) {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSFTReps() {
        int reps = -1;
        try {
            reps = this.getAll("SFT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        UAC ret = null;
        try {
            ret = (UAC)this.get("UAC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public UAC getUAC(int rep) {
        UAC ret = null;
        try {
            ret = (UAC)this.get("UAC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getUACReps() {
        int reps = -1;
        try {
            reps = this.getAll("UAC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertUAC(UAC structure, int rep) throws HL7Exception {
        super.insertRepetition("UAC", (Structure)structure, rep);
    }

    public UAC insertUAC(int rep) throws HL7Exception {
        return (UAC)super.insertRepetition("UAC", rep);
    }

    public UAC removeUAC(int rep) throws HL7Exception {
        return (UAC)super.removeRepetition("UAC", rep);
    }

    public IVC getIVC() {
        IVC ret = null;
        try {
            ret = (IVC)this.get("IVC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E21_PSL_ITEM_INFO getPSL_ITEM_INFO() {
        EHC_E21_PSL_ITEM_INFO ret = null;
        try {
            ret = (EHC_E21_PSL_ITEM_INFO)this.get("PSL_ITEM_INFO");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E21_PSL_ITEM_INFO getPSL_ITEM_INFO(int rep) {
        EHC_E21_PSL_ITEM_INFO ret = null;
        try {
            ret = (EHC_E21_PSL_ITEM_INFO)this.get("PSL_ITEM_INFO", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPSL_ITEM_INFOReps() {
        int reps = -1;
        try {
            reps = this.getAll("PSL_ITEM_INFO").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPSL_ITEM_INFO(EHC_E21_PSL_ITEM_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("PSL_ITEM_INFO", (Structure)structure, rep);
    }

    public EHC_E21_PSL_ITEM_INFO insertPSL_ITEM_INFO(int rep) throws HL7Exception {
        return (EHC_E21_PSL_ITEM_INFO)super.insertRepetition("PSL_ITEM_INFO", rep);
    }

    public EHC_E21_PSL_ITEM_INFO removePSL_ITEM_INFO(int rep) throws HL7Exception {
        return (EHC_E21_PSL_ITEM_INFO)super.removeRepetition("PSL_ITEM_INFO", rep);
    }
}

