/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.CX;
import ca.uhn.hl7v2.model.v26.datatype.DT;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.JCC;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.XAD;
import ca.uhn.hl7v2.model.v26.datatype.XON;
import ca.uhn.hl7v2.model.v26.datatype.XPN;
import ca.uhn.hl7v2.model.v26.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class NK1
extends AbstractSegment {
    public NK1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "Set ID - NK1");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(200)}, "Name");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(63)}, "Relationship");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Address");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Phone Number");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Business Phone Number");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(131)}, "Contact Role");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(0)}, "Start Date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(0)}, "End Date");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "Next of Kin / Associated Parties Job Title");
            this.add(JCC.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Next of Kin / Associated Parties Job Code/Class");
            this.add(CX.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Next of Kin / Associated Parties Employee Number");
            this.add(XON.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Organization Name - NK1");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(2)}, "Marital Status");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage()}, "Administrative Sex");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage(), new Integer(0)}, "Date/Time of Birth");
            this.add(IS.class, false, 0, 2, new Object[]{this.getMessage()}, "Living Dependency");
            this.add(IS.class, false, 0, 2, new Object[]{this.getMessage()}, "Ambulatory Status");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage(), new Integer(171)}, "Citizenship");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(296)}, "Primary Language");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Living Arrangement");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(215)}, "Publicity Code");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage()}, "Protection Indicator");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Student Indicator");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(6)}, "Religion");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Mother's Maiden Name");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(212)}, "Nationality");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage(), new Integer(189)}, "Ethnic Group");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage(), new Integer(222)}, "Contact Reason");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(200)}, "Contact Person's Name");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Contact Person's Telephone Number");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Contact Person's Address");
            this.add(CX.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Next of Kin/Associated Party's Identifiers");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Job Status");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage(), new Integer(5)}, "Race");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Handicap");
            this.add(ST.class, false, 1, 16, new Object[]{this.getMessage(), new Integer(0)}, "Contact Person Social Security Number");
            this.add(ST.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Next of Kin Birth Place");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "VIP Indicator");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating NK1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDNK1() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SI getNk11_SetIDNK1() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN[] getNK1Name() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(2);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNK1NameReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN getNK1Name(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getNk12_Name(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk12_NameReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertNK1Name(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(2, rep);
    }

    public XPN insertNk12_Name(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(2, rep);
    }

    public XPN removeNK1Name(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(2, rep);
    }

    public XPN removeNk12_Name(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(2, rep);
    }

    public CWE getRelationship() {
        CWE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getNk13_Relationship() {
        CWE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD[] getAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(4);
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XAD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getAddressReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(4);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XAD getAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getNk14_Address(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk14_AddressReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(4);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XAD insertAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(4, rep);
    }

    public XAD insertNk14_Address(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(4, rep);
    }

    public XAD removeAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(4, rep);
    }

    public XAD removeNk14_Address(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(4, rep);
    }

    public XTN[] getPhoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(5);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPhoneNumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN getPhoneNumber(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN getNk15_PhoneNumber(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk15_PhoneNumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(5, rep);
    }

    public XTN insertNk15_PhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(5, rep);
    }

    public XTN removePhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(5, rep);
    }

    public XTN removeNk15_PhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(5, rep);
    }

    public XTN[] getBusinessPhoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(6);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getBusinessPhoneNumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(6);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN getBusinessPhoneNumber(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN getNk16_BusinessPhoneNumber(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk16_BusinessPhoneNumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(6);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertBusinessPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(6, rep);
    }

    public XTN insertNk16_BusinessPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(6, rep);
    }

    public XTN removeBusinessPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(6, rep);
    }

    public XTN removeNk16_BusinessPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(6, rep);
    }

    public CWE getContactRole() {
        CWE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getNk17_ContactRole() {
        CWE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getStartDate() {
        DT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getNk18_StartDate() {
        DT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getEndDate() {
        DT ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getNk19_EndDate() {
        DT ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getNextOfKinAssociatedPartiesJobTitle() {
        ST ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getNk110_NextOfKinAssociatedPartiesJobTitle() {
        ST ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public JCC getNextOfKinAssociatedPartiesJobCodeClass() {
        JCC ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (JCC)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public JCC getNk111_NextOfKinAssociatedPartiesJobCodeClass() {
        JCC ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (JCC)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getNextOfKinAssociatedPartiesEmployeeNumber() {
        CX ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getNk112_NextOfKinAssociatedPartiesEmployeeNumber() {
        CX ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON[] getOrganizationNameNK1() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(13);
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XON)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getOrganizationNameNK1Reps() {
        Object ret = null;
        try {
            Type[] t = this.getField(13);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XON getOrganizationNameNK1(int rep) {
        XON ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XON getNk113_OrganizationNameNK1(int rep) {
        XON ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (XON)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk113_OrganizationNameNK1Reps() {
        Object ret = null;
        try {
            Type[] t = this.getField(13);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XON insertOrganizationNameNK1(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(13, rep);
    }

    public XON insertNk113_OrganizationNameNK1(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(13, rep);
    }

    public XON removeOrganizationNameNK1(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(13, rep);
    }

    public XON removeNk113_OrganizationNameNK1(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(13, rep);
    }

    public CWE getMaritalStatus() {
        CWE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getNk114_MaritalStatus() {
        CWE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getAdministrativeSex() {
        IS ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getNk115_AdministrativeSex() {
        IS ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getDateTimeOfBirth() {
        DTM ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getNk116_DateTimeOfBirth() {
        DTM ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS[] getLivingDependency() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(17);
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (IS)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getLivingDependencyReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(17);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public IS getLivingDependency(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getNk117_LivingDependency(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk117_LivingDependencyReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(17);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public IS insertLivingDependency(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(17, rep);
    }

    public IS insertNk117_LivingDependency(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(17, rep);
    }

    public IS removeLivingDependency(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(17, rep);
    }

    public IS removeNk117_LivingDependency(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(17, rep);
    }

    public IS[] getAmbulatoryStatus() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(18);
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (IS)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getAmbulatoryStatusReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(18);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public IS getAmbulatoryStatus(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getNk118_AmbulatoryStatus(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk118_AmbulatoryStatusReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(18);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public IS insertAmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(18, rep);
    }

    public IS insertNk118_AmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(18, rep);
    }

    public IS removeAmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(18, rep);
    }

    public IS removeNk118_AmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(18, rep);
    }

    public CWE[] getCitizenship() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(19);
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CWE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getCitizenshipReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(19);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CWE getCitizenship(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getNk119_Citizenship(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk119_CitizenshipReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(19);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CWE insertCitizenship(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(19, rep);
    }

    public CWE insertNk119_Citizenship(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(19, rep);
    }

    public CWE removeCitizenship(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(19, rep);
    }

    public CWE removeNk119_Citizenship(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(19, rep);
    }

    public CWE getPrimaryLanguage() {
        CWE ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getNk120_PrimaryLanguage() {
        CWE ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getLivingArrangement() {
        IS ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getNk121_LivingArrangement() {
        IS ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getPublicityCode() {
        CWE ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getNk122_PublicityCode() {
        CWE ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getProtectionIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getNk123_ProtectionIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getStudentIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getNk124_StudentIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getReligion() {
        CWE ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getNk125_Religion() {
        CWE ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN[] getMotherSMaidenName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(26);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getMotherSMaidenNameReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(26);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN getMotherSMaidenName(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(26, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getNk126_MotherSMaidenName(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(26, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk126_MotherSMaidenNameReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(26);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertMotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(26, rep);
    }

    public XPN insertNk126_MotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(26, rep);
    }

    public XPN removeMotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(26, rep);
    }

    public XPN removeNk126_MotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(26, rep);
    }

    public CWE getNationality() {
        CWE ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getNk127_Nationality() {
        CWE ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE[] getEthnicGroup() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(28);
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CWE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEthnicGroupReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(28);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CWE getEthnicGroup(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getNk128_EthnicGroup(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk128_EthnicGroupReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(28);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CWE insertEthnicGroup(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(28, rep);
    }

    public CWE insertNk128_EthnicGroup(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(28, rep);
    }

    public CWE removeEthnicGroup(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(28, rep);
    }

    public CWE removeNk128_EthnicGroup(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(28, rep);
    }

    public CWE[] getContactReason() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(29);
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CWE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getContactReasonReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(29);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CWE getContactReason(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(29, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getNk129_ContactReason(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(29, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk129_ContactReasonReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(29);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CWE insertContactReason(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(29, rep);
    }

    public CWE insertNk129_ContactReason(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(29, rep);
    }

    public CWE removeContactReason(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(29, rep);
    }

    public CWE removeNk129_ContactReason(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(29, rep);
    }

    public XPN[] getContactPersonSName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(30);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getContactPersonSNameReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(30);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN getContactPersonSName(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(30, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getNk130_ContactPersonSName(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(30, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk130_ContactPersonSNameReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(30);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(30, rep);
    }

    public XPN insertNk130_ContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(30, rep);
    }

    public XPN removeContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(30, rep);
    }

    public XPN removeNk130_ContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(30, rep);
    }

    public XTN[] getContactPersonSTelephoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(31);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getContactPersonSTelephoneNumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(31);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN getContactPersonSTelephoneNumber(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(31, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN getNk131_ContactPersonSTelephoneNumber(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(31, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk131_ContactPersonSTelephoneNumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(31);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(31, rep);
    }

    public XTN insertNk131_ContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(31, rep);
    }

    public XTN removeContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(31, rep);
    }

    public XTN removeNk131_ContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(31, rep);
    }

    public XAD[] getContactPersonSAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(32);
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XAD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getContactPersonSAddressReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(32);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XAD getContactPersonSAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(32, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getNk132_ContactPersonSAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(32, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk132_ContactPersonSAddressReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(32);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XAD insertContactPersonSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(32, rep);
    }

    public XAD insertNk132_ContactPersonSAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(32, rep);
    }

    public XAD removeContactPersonSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(32, rep);
    }

    public XAD removeNk132_ContactPersonSAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(32, rep);
    }

    public CX[] getNextOfKinAssociatedPartySIdentifiers() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(33);
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CX)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNextOfKinAssociatedPartySIdentifiersReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(33);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX getNextOfKinAssociatedPartySIdentifiers(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(33, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getNk133_NextOfKinAssociatedPartySIdentifiers(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(33, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk133_NextOfKinAssociatedPartySIdentifiersReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(33);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX insertNextOfKinAssociatedPartySIdentifiers(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(33, rep);
    }

    public CX insertNk133_NextOfKinAssociatedPartySIdentifiers(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(33, rep);
    }

    public CX removeNextOfKinAssociatedPartySIdentifiers(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(33, rep);
    }

    public CX removeNk133_NextOfKinAssociatedPartySIdentifiers(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(33, rep);
    }

    public IS getJobStatus() {
        IS ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getNk134_JobStatus() {
        IS ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE[] getRace() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(35);
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CWE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getRaceReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(35);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CWE getRace(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(35, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getNk135_Race(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(35, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNk135_RaceReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(35);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CWE insertRace(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(35, rep);
    }

    public CWE insertNk135_Race(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(35, rep);
    }

    public CWE removeRace(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(35, rep);
    }

    public CWE removeNk135_Race(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(35, rep);
    }

    public IS getHandicap() {
        IS ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getNk136_Handicap() {
        IS ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getContactPersonSocialSecurityNumber() {
        ST ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getNk137_ContactPersonSocialSecurityNumber() {
        ST ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getNextOfKinBirthPlace() {
        ST ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getNk138_NextOfKinBirthPlace() {
        ST ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getVIPIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getNk139_VIPIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new XPN(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new XAD(this.getMessage());
            }
            case 4: {
                return new XTN(this.getMessage());
            }
            case 5: {
                return new XTN(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new DT(this.getMessage());
            }
            case 8: {
                return new DT(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new JCC(this.getMessage());
            }
            case 11: {
                return new CX(this.getMessage());
            }
            case 12: {
                return new XON(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new IS(this.getMessage(), new Integer(1));
            }
            case 15: {
                return new DTM(this.getMessage());
            }
            case 16: {
                return new IS(this.getMessage(), new Integer(223));
            }
            case 17: {
                return new IS(this.getMessage(), new Integer(9));
            }
            case 18: {
                return new CWE(this.getMessage());
            }
            case 19: {
                return new CWE(this.getMessage());
            }
            case 20: {
                return new IS(this.getMessage(), new Integer(220));
            }
            case 21: {
                return new CWE(this.getMessage());
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 23: {
                return new IS(this.getMessage(), new Integer(231));
            }
            case 24: {
                return new CWE(this.getMessage());
            }
            case 25: {
                return new XPN(this.getMessage());
            }
            case 26: {
                return new CWE(this.getMessage());
            }
            case 27: {
                return new CWE(this.getMessage());
            }
            case 28: {
                return new CWE(this.getMessage());
            }
            case 29: {
                return new XPN(this.getMessage());
            }
            case 30: {
                return new XTN(this.getMessage());
            }
            case 31: {
                return new XAD(this.getMessage());
            }
            case 32: {
                return new CX(this.getMessage());
            }
            case 33: {
                return new IS(this.getMessage(), new Integer(311));
            }
            case 34: {
                return new CWE(this.getMessage());
            }
            case 35: {
                return new IS(this.getMessage(), new Integer(295));
            }
            case 36: {
                return new ST(this.getMessage());
            }
            case 37: {
                return new ST(this.getMessage());
            }
            case 38: {
                return new IS(this.getMessage(), new Integer(99));
            }
        }
        return null;
    }
}

