/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DR;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.PL;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PDA
extends AbstractSegment {
    public PDA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage(), new Integer(0)}, "Death Cause Code");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage(), new Integer(0)}, "Death Location");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Death Certified Indicator");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage(), new Integer(0)}, "Death Certificate Signed Date/Time");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Death Certified By");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Autopsy Indicator");
            this.add(DR.class, false, 1, 53, new Object[]{this.getMessage(), new Integer(0)}, "Autopsy Start and End Date/Time");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Autopsy Performed By");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Coroner Indicator");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating PDA - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE[] getDeathCauseCode() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(1);
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CWE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getDeathCauseCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CWE getDeathCauseCode(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getPda1_DeathCauseCode(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPda1_DeathCauseCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CWE insertDeathCauseCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(1, rep);
    }

    public CWE insertPda1_DeathCauseCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(1, rep);
    }

    public CWE removeDeathCauseCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(1, rep);
    }

    public CWE removePda1_DeathCauseCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(1, rep);
    }

    public PL getDeathLocation() {
        PL ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PL getPda2_DeathLocation() {
        PL ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getDeathCertifiedIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPda3_DeathCertifiedIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getDeathCertificateSignedDateTime() {
        DTM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getPda4_DeathCertificateSignedDateTime() {
        DTM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getDeathCertifiedBy() {
        XCN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getPda5_DeathCertifiedBy() {
        XCN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getAutopsyIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPda6_AutopsyIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DR getAutopsyStartAndEndDateTime() {
        DR ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (DR)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DR getPda7_AutopsyStartAndEndDateTime() {
        DR ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (DR)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getAutopsyPerformedBy() {
        XCN ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getPda8_AutopsyPerformedBy() {
        XCN ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getCoronerIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPda9_CoronerIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new PL(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new XCN(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 6: {
                return new DR(this.getMessage());
            }
            case 7: {
                return new XCN(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

