/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.MO;
import org.slf4j.LoggerFactory;

public class UVC
extends AbstractType
implements Composite {
    private Type[] data;

    public UVC(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[2];
        this.data[0] = new CNE(this.getMessage());
        this.data[1] = new MO(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CNE getValueCode() {
        CNE ret = null;
        try {
            ret = (CNE)this.getComponent(0);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CNE getUvc1_ValueCode() {
        CNE ret = null;
        try {
            ret = (CNE)this.getComponent(0);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MO getValueAmount() {
        MO ret = null;
        try {
            ret = (MO)this.getComponent(1);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MO getUvc2_ValueAmount() {
        MO ret = null;
        try {
            ret = (MO)this.getComponent(1);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

