/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.EHC_E02_PSG;
import ca.uhn.hl7v2.model.v26.segment.PSS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EHC_E02_PRODUCT_SERVICE_SECTION
extends AbstractGroup {
    public EHC_E02_PRODUCT_SERVICE_SECTION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PSS.class, true, false);
            this.add(EHC_E02_PSG.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating EHC_E02_PRODUCT_SERVICE_SECTION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PSS getPSS() {
        PSS ret = null;
        try {
            ret = (PSS)this.get("PSS");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E02_PSG getPSG() {
        EHC_E02_PSG ret = null;
        try {
            ret = (EHC_E02_PSG)this.get("PSG");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E02_PSG getPSG(int rep) {
        EHC_E02_PSG ret = null;
        try {
            ret = (EHC_E02_PSG)this.get("PSG", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPSGReps() {
        int reps = -1;
        try {
            reps = this.getAll("PSG").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<EHC_E02_PSG> getPSGAll() throws HL7Exception {
        return this.getAllAsList("PSG", EHC_E02_PSG.class);
    }

    public void insertPSG(EHC_E02_PSG structure, int rep) throws HL7Exception {
        super.insertRepetition("PSG", (Structure)structure, rep);
    }

    public EHC_E02_PSG insertPSG(int rep) throws HL7Exception {
        return (EHC_E02_PSG)super.insertRepetition("PSG", rep);
    }

    public EHC_E02_PSG removePSG(int rep) throws HL7Exception {
        return (EHC_E02_PSG)super.removeRepetition("PSG", rep);
    }
}

