/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.EHC_E04_PRODUCT_SERVICE_GROUP;
import ca.uhn.hl7v2.model.v26.segment.PSS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EHC_E04_PRODUCT_SERVICE_SECTION
extends AbstractGroup {
    public EHC_E04_PRODUCT_SERVICE_SECTION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PSS.class, true, false);
            this.add(EHC_E04_PRODUCT_SERVICE_GROUP.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating EHC_E04_PRODUCT_SERVICE_SECTION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PSS getPSS() {
        PSS ret = null;
        try {
            ret = (PSS)this.get("PSS");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E04_PRODUCT_SERVICE_GROUP getPRODUCT_SERVICE_GROUP() {
        EHC_E04_PRODUCT_SERVICE_GROUP ret = null;
        try {
            ret = (EHC_E04_PRODUCT_SERVICE_GROUP)this.get("PRODUCT_SERVICE_GROUP");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E04_PRODUCT_SERVICE_GROUP getPRODUCT_SERVICE_GROUP(int rep) {
        EHC_E04_PRODUCT_SERVICE_GROUP ret = null;
        try {
            ret = (EHC_E04_PRODUCT_SERVICE_GROUP)this.get("PRODUCT_SERVICE_GROUP", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPRODUCT_SERVICE_GROUPReps() {
        int reps = -1;
        try {
            reps = this.getAll("PRODUCT_SERVICE_GROUP").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<EHC_E04_PRODUCT_SERVICE_GROUP> getPRODUCT_SERVICE_GROUPAll() throws HL7Exception {
        return this.getAllAsList("PRODUCT_SERVICE_GROUP", EHC_E04_PRODUCT_SERVICE_GROUP.class);
    }

    public void insertPRODUCT_SERVICE_GROUP(EHC_E04_PRODUCT_SERVICE_GROUP structure, int rep) throws HL7Exception {
        super.insertRepetition("PRODUCT_SERVICE_GROUP", (Structure)structure, rep);
    }

    public EHC_E04_PRODUCT_SERVICE_GROUP insertPRODUCT_SERVICE_GROUP(int rep) throws HL7Exception {
        return (EHC_E04_PRODUCT_SERVICE_GROUP)super.insertRepetition("PRODUCT_SERVICE_GROUP", rep);
    }

    public EHC_E04_PRODUCT_SERVICE_GROUP removePRODUCT_SERVICE_GROUP(int rep) throws HL7Exception {
        return (EHC_E04_PRODUCT_SERVICE_GROUP)super.removeRepetition("PRODUCT_SERVICE_GROUP", rep);
    }
}

