/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.EHC_E20_DIAGNOSIS;
import ca.uhn.hl7v2.model.v26.group.EHC_E20_INSURANCE;
import ca.uhn.hl7v2.model.v26.segment.ACC;
import ca.uhn.hl7v2.model.v26.segment.OBX;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EHC_E20_PAT_INFO
extends AbstractGroup {
    public EHC_E20_PAT_INFO(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false);
            this.add(ACC.class, false, true);
            this.add(EHC_E20_INSURANCE.class, true, true);
            this.add(EHC_E20_DIAGNOSIS.class, false, true);
            this.add(OBX.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating EHC_E20_PAT_INFO - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ACC getACC() {
        ACC ret = null;
        try {
            ret = (ACC)this.get("ACC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ACC getACC(int rep) {
        ACC ret = null;
        try {
            ret = (ACC)this.get("ACC", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getACCReps() {
        int reps = -1;
        try {
            reps = this.getAll("ACC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ACC> getACCAll() throws HL7Exception {
        return this.getAllAsList("ACC", ACC.class);
    }

    public void insertACC(ACC structure, int rep) throws HL7Exception {
        super.insertRepetition("ACC", (Structure)structure, rep);
    }

    public ACC insertACC(int rep) throws HL7Exception {
        return (ACC)super.insertRepetition("ACC", rep);
    }

    public ACC removeACC(int rep) throws HL7Exception {
        return (ACC)super.removeRepetition("ACC", rep);
    }

    public EHC_E20_INSURANCE getINSURANCE() {
        EHC_E20_INSURANCE ret = null;
        try {
            ret = (EHC_E20_INSURANCE)this.get("INSURANCE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E20_INSURANCE getINSURANCE(int rep) {
        EHC_E20_INSURANCE ret = null;
        try {
            ret = (EHC_E20_INSURANCE)this.get("INSURANCE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getINSURANCEReps() {
        int reps = -1;
        try {
            reps = this.getAll("INSURANCE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<EHC_E20_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", EHC_E20_INSURANCE.class);
    }

    public void insertINSURANCE(EHC_E20_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", (Structure)structure, rep);
    }

    public EHC_E20_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (EHC_E20_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public EHC_E20_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (EHC_E20_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public EHC_E20_DIAGNOSIS getDIAGNOSIS() {
        EHC_E20_DIAGNOSIS ret = null;
        try {
            ret = (EHC_E20_DIAGNOSIS)this.get("DIAGNOSIS");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E20_DIAGNOSIS getDIAGNOSIS(int rep) {
        EHC_E20_DIAGNOSIS ret = null;
        try {
            ret = (EHC_E20_DIAGNOSIS)this.get("DIAGNOSIS", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getDIAGNOSISReps() {
        int reps = -1;
        try {
            reps = this.getAll("DIAGNOSIS").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<EHC_E20_DIAGNOSIS> getDIAGNOSISAll() throws HL7Exception {
        return this.getAllAsList("DIAGNOSIS", EHC_E20_DIAGNOSIS.class);
    }

    public void insertDIAGNOSIS(EHC_E20_DIAGNOSIS structure, int rep) throws HL7Exception {
        super.insertRepetition("DIAGNOSIS", (Structure)structure, rep);
    }

    public EHC_E20_DIAGNOSIS insertDIAGNOSIS(int rep) throws HL7Exception {
        return (EHC_E20_DIAGNOSIS)super.insertRepetition("DIAGNOSIS", rep);
    }

    public EHC_E20_DIAGNOSIS removeDIAGNOSIS(int rep) throws HL7Exception {
        return (EHC_E20_DIAGNOSIS)super.removeRepetition("DIAGNOSIS", rep);
    }

    public OBX getOBX() {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBX getOBX(int rep) {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBXReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBX").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }
}

