/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.segment.AFF;
import ca.uhn.hl7v2.model.v26.segment.CER;
import ca.uhn.hl7v2.model.v26.segment.EDU;
import ca.uhn.hl7v2.model.v26.segment.LAN;
import ca.uhn.hl7v2.model.v26.segment.MFE;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.ORG;
import ca.uhn.hl7v2.model.v26.segment.PRA;
import ca.uhn.hl7v2.model.v26.segment.STF;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_M02_MF_STAFF
extends AbstractGroup {
    public MFN_M02_MF_STAFF(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false);
            this.add(STF.class, true, false);
            this.add(PRA.class, false, true);
            this.add(ORG.class, false, true);
            this.add(AFF.class, false, true);
            this.add(LAN.class, false, true);
            this.add(EDU.class, false, true);
            this.add(CER.class, false, true);
            this.add(NTE.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating MFN_M02_MF_STAFF - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MFE getMFE() {
        MFE ret = null;
        try {
            ret = (MFE)this.get("MFE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public STF getSTF() {
        STF ret = null;
        try {
            ret = (STF)this.get("STF");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRA getPRA() {
        PRA ret = null;
        try {
            ret = (PRA)this.get("PRA");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRA getPRA(int rep) {
        PRA ret = null;
        try {
            ret = (PRA)this.get("PRA", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPRAReps() {
        int reps = -1;
        try {
            reps = this.getAll("PRA").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<PRA> getPRAAll() throws HL7Exception {
        return this.getAllAsList("PRA", PRA.class);
    }

    public void insertPRA(PRA structure, int rep) throws HL7Exception {
        super.insertRepetition("PRA", (Structure)structure, rep);
    }

    public PRA insertPRA(int rep) throws HL7Exception {
        return (PRA)super.insertRepetition("PRA", rep);
    }

    public PRA removePRA(int rep) throws HL7Exception {
        return (PRA)super.removeRepetition("PRA", rep);
    }

    public ORG getORG() {
        ORG ret = null;
        try {
            ret = (ORG)this.get("ORG");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORG getORG(int rep) {
        ORG ret = null;
        try {
            ret = (ORG)this.get("ORG", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORGReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORG").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ORG> getORGAll() throws HL7Exception {
        return this.getAllAsList("ORG", ORG.class);
    }

    public void insertORG(ORG structure, int rep) throws HL7Exception {
        super.insertRepetition("ORG", (Structure)structure, rep);
    }

    public ORG insertORG(int rep) throws HL7Exception {
        return (ORG)super.insertRepetition("ORG", rep);
    }

    public ORG removeORG(int rep) throws HL7Exception {
        return (ORG)super.removeRepetition("ORG", rep);
    }

    public AFF getAFF() {
        AFF ret = null;
        try {
            ret = (AFF)this.get("AFF");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public AFF getAFF(int rep) {
        AFF ret = null;
        try {
            ret = (AFF)this.get("AFF", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getAFFReps() {
        int reps = -1;
        try {
            reps = this.getAll("AFF").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<AFF> getAFFAll() throws HL7Exception {
        return this.getAllAsList("AFF", AFF.class);
    }

    public void insertAFF(AFF structure, int rep) throws HL7Exception {
        super.insertRepetition("AFF", (Structure)structure, rep);
    }

    public AFF insertAFF(int rep) throws HL7Exception {
        return (AFF)super.insertRepetition("AFF", rep);
    }

    public AFF removeAFF(int rep) throws HL7Exception {
        return (AFF)super.removeRepetition("AFF", rep);
    }

    public LAN getLAN() {
        LAN ret = null;
        try {
            ret = (LAN)this.get("LAN");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LAN getLAN(int rep) {
        LAN ret = null;
        try {
            ret = (LAN)this.get("LAN", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getLANReps() {
        int reps = -1;
        try {
            reps = this.getAll("LAN").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<LAN> getLANAll() throws HL7Exception {
        return this.getAllAsList("LAN", LAN.class);
    }

    public void insertLAN(LAN structure, int rep) throws HL7Exception {
        super.insertRepetition("LAN", (Structure)structure, rep);
    }

    public LAN insertLAN(int rep) throws HL7Exception {
        return (LAN)super.insertRepetition("LAN", rep);
    }

    public LAN removeLAN(int rep) throws HL7Exception {
        return (LAN)super.removeRepetition("LAN", rep);
    }

    public EDU getEDU() {
        EDU ret = null;
        try {
            ret = (EDU)this.get("EDU");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EDU getEDU(int rep) {
        EDU ret = null;
        try {
            ret = (EDU)this.get("EDU", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getEDUReps() {
        int reps = -1;
        try {
            reps = this.getAll("EDU").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<EDU> getEDUAll() throws HL7Exception {
        return this.getAllAsList("EDU", EDU.class);
    }

    public void insertEDU(EDU structure, int rep) throws HL7Exception {
        super.insertRepetition("EDU", (Structure)structure, rep);
    }

    public EDU insertEDU(int rep) throws HL7Exception {
        return (EDU)super.insertRepetition("EDU", rep);
    }

    public EDU removeEDU(int rep) throws HL7Exception {
        return (EDU)super.removeRepetition("EDU", rep);
    }

    public CER getCER() {
        CER ret = null;
        try {
            ret = (CER)this.get("CER");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CER getCER(int rep) {
        CER ret = null;
        try {
            ret = (CER)this.get("CER", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCERReps() {
        int reps = -1;
        try {
            reps = this.getAll("CER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<CER> getCERAll() throws HL7Exception {
        return this.getAllAsList("CER", CER.class);
    }

    public void insertCER(CER structure, int rep) throws HL7Exception {
        super.insertRepetition("CER", (Structure)structure, rep);
    }

    public CER insertCER(int rep) throws HL7Exception {
        return (CER)super.insertRepetition("CER", rep);
    }

    public CER removeCER(int rep) throws HL7Exception {
        return (CER)super.removeRepetition("CER", rep);
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

