/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.MFN_M16_MATERIAL_LOCATION;
import ca.uhn.hl7v2.model.v26.group.MFN_M16_PURCHASING_VENDOR;
import ca.uhn.hl7v2.model.v26.group.MFN_M16_STERILIZATION;
import ca.uhn.hl7v2.model.v26.segment.ITM;
import ca.uhn.hl7v2.model.v26.segment.MFE;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_M16_MATERIAL_ITEM_RECORD
extends AbstractGroup {
    public MFN_M16_MATERIAL_ITEM_RECORD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false);
            this.add(ITM.class, true, false);
            this.add(NTE.class, false, true);
            this.add(MFN_M16_STERILIZATION.class, false, true);
            this.add(MFN_M16_PURCHASING_VENDOR.class, false, true);
            this.add(MFN_M16_MATERIAL_LOCATION.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating MFN_M16_MATERIAL_ITEM_RECORD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MFE getMFE() {
        MFE ret = null;
        try {
            ret = (MFE)this.get("MFE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ITM getITM() {
        ITM ret = null;
        try {
            ret = (ITM)this.get("ITM");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public MFN_M16_STERILIZATION getSTERILIZATION() {
        MFN_M16_STERILIZATION ret = null;
        try {
            ret = (MFN_M16_STERILIZATION)this.get("STERILIZATION");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M16_STERILIZATION getSTERILIZATION(int rep) {
        MFN_M16_STERILIZATION ret = null;
        try {
            ret = (MFN_M16_STERILIZATION)this.get("STERILIZATION", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSTERILIZATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("STERILIZATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<MFN_M16_STERILIZATION> getSTERILIZATIONAll() throws HL7Exception {
        return this.getAllAsList("STERILIZATION", MFN_M16_STERILIZATION.class);
    }

    public void insertSTERILIZATION(MFN_M16_STERILIZATION structure, int rep) throws HL7Exception {
        super.insertRepetition("STERILIZATION", (Structure)structure, rep);
    }

    public MFN_M16_STERILIZATION insertSTERILIZATION(int rep) throws HL7Exception {
        return (MFN_M16_STERILIZATION)super.insertRepetition("STERILIZATION", rep);
    }

    public MFN_M16_STERILIZATION removeSTERILIZATION(int rep) throws HL7Exception {
        return (MFN_M16_STERILIZATION)super.removeRepetition("STERILIZATION", rep);
    }

    public MFN_M16_PURCHASING_VENDOR getPURCHASING_VENDOR() {
        MFN_M16_PURCHASING_VENDOR ret = null;
        try {
            ret = (MFN_M16_PURCHASING_VENDOR)this.get("PURCHASING_VENDOR");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M16_PURCHASING_VENDOR getPURCHASING_VENDOR(int rep) {
        MFN_M16_PURCHASING_VENDOR ret = null;
        try {
            ret = (MFN_M16_PURCHASING_VENDOR)this.get("PURCHASING_VENDOR", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPURCHASING_VENDORReps() {
        int reps = -1;
        try {
            reps = this.getAll("PURCHASING_VENDOR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<MFN_M16_PURCHASING_VENDOR> getPURCHASING_VENDORAll() throws HL7Exception {
        return this.getAllAsList("PURCHASING_VENDOR", MFN_M16_PURCHASING_VENDOR.class);
    }

    public void insertPURCHASING_VENDOR(MFN_M16_PURCHASING_VENDOR structure, int rep) throws HL7Exception {
        super.insertRepetition("PURCHASING_VENDOR", (Structure)structure, rep);
    }

    public MFN_M16_PURCHASING_VENDOR insertPURCHASING_VENDOR(int rep) throws HL7Exception {
        return (MFN_M16_PURCHASING_VENDOR)super.insertRepetition("PURCHASING_VENDOR", rep);
    }

    public MFN_M16_PURCHASING_VENDOR removePURCHASING_VENDOR(int rep) throws HL7Exception {
        return (MFN_M16_PURCHASING_VENDOR)super.removeRepetition("PURCHASING_VENDOR", rep);
    }

    public MFN_M16_MATERIAL_LOCATION getMATERIAL_LOCATION() {
        MFN_M16_MATERIAL_LOCATION ret = null;
        try {
            ret = (MFN_M16_MATERIAL_LOCATION)this.get("MATERIAL_LOCATION");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M16_MATERIAL_LOCATION getMATERIAL_LOCATION(int rep) {
        MFN_M16_MATERIAL_LOCATION ret = null;
        try {
            ret = (MFN_M16_MATERIAL_LOCATION)this.get("MATERIAL_LOCATION", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getMATERIAL_LOCATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("MATERIAL_LOCATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<MFN_M16_MATERIAL_LOCATION> getMATERIAL_LOCATIONAll() throws HL7Exception {
        return this.getAllAsList("MATERIAL_LOCATION", MFN_M16_MATERIAL_LOCATION.class);
    }

    public void insertMATERIAL_LOCATION(MFN_M16_MATERIAL_LOCATION structure, int rep) throws HL7Exception {
        super.insertRepetition("MATERIAL_LOCATION", (Structure)structure, rep);
    }

    public MFN_M16_MATERIAL_LOCATION insertMATERIAL_LOCATION(int rep) throws HL7Exception {
        return (MFN_M16_MATERIAL_LOCATION)super.insertRepetition("MATERIAL_LOCATION", rep);
    }

    public MFN_M16_MATERIAL_LOCATION removeMATERIAL_LOCATION(int rep) throws HL7Exception {
        return (MFN_M16_MATERIAL_LOCATION)super.removeRepetition("MATERIAL_LOCATION", rep);
    }
}

