/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.OML_O21_OBSERVATION_REQUEST;
import ca.uhn.hl7v2.model.v26.group.OML_O21_TIMING;
import ca.uhn.hl7v2.model.v26.segment.BLG;
import ca.uhn.hl7v2.model.v26.segment.CTI;
import ca.uhn.hl7v2.model.v26.segment.FT1;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OML_O21_ORDER
extends AbstractGroup {
    public OML_O21_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(OML_O21_TIMING.class, false, true);
            this.add(OML_O21_OBSERVATION_REQUEST.class, false, false);
            this.add(FT1.class, false, true);
            this.add(CTI.class, false, true);
            this.add(BLG.class, false, false);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating OML_O21_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OML_O21_TIMING getTIMING() {
        OML_O21_TIMING ret = null;
        try {
            ret = (OML_O21_TIMING)this.get("TIMING");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OML_O21_TIMING getTIMING(int rep) {
        OML_O21_TIMING ret = null;
        try {
            ret = (OML_O21_TIMING)this.get("TIMING", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<OML_O21_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", OML_O21_TIMING.class);
    }

    public void insertTIMING(OML_O21_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public OML_O21_TIMING insertTIMING(int rep) throws HL7Exception {
        return (OML_O21_TIMING)super.insertRepetition("TIMING", rep);
    }

    public OML_O21_TIMING removeTIMING(int rep) throws HL7Exception {
        return (OML_O21_TIMING)super.removeRepetition("TIMING", rep);
    }

    public OML_O21_OBSERVATION_REQUEST getOBSERVATION_REQUEST() {
        OML_O21_OBSERVATION_REQUEST ret = null;
        try {
            ret = (OML_O21_OBSERVATION_REQUEST)this.get("OBSERVATION_REQUEST");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public FT1 getFT1() {
        FT1 ret = null;
        try {
            ret = (FT1)this.get("FT1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public FT1 getFT1(int rep) {
        FT1 ret = null;
        try {
            ret = (FT1)this.get("FT1", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getFT1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("FT1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<FT1> getFT1All() throws HL7Exception {
        return this.getAllAsList("FT1", FT1.class);
    }

    public void insertFT1(FT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("FT1", (Structure)structure, rep);
    }

    public FT1 insertFT1(int rep) throws HL7Exception {
        return (FT1)super.insertRepetition("FT1", rep);
    }

    public FT1 removeFT1(int rep) throws HL7Exception {
        return (FT1)super.removeRepetition("FT1", rep);
    }

    public CTI getCTI() {
        CTI ret = null;
        try {
            ret = (CTI)this.get("CTI");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CTI getCTI(int rep) {
        CTI ret = null;
        try {
            ret = (CTI)this.get("CTI", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCTIReps() {
        int reps = -1;
        try {
            reps = this.getAll("CTI").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", (Structure)structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }

    public BLG getBLG() {
        BLG ret = null;
        try {
            ret = (BLG)this.get("BLG");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

