/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.OML_O35_OBSERVATION_PRIOR;
import ca.uhn.hl7v2.model.v26.group.OML_O35_TIMING_PRIOR;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.OBR;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OML_O35_ORDER_PRIOR
extends AbstractGroup {
    public OML_O35_ORDER_PRIOR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false);
            this.add(OBR.class, true, false);
            this.add(NTE.class, false, true);
            this.add(ROL.class, false, true);
            this.add(OML_O35_TIMING_PRIOR.class, false, true);
            this.add(OML_O35_OBSERVATION_PRIOR.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating OML_O35_ORDER_PRIOR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBR getOBR() {
        OBR ret = null;
        try {
            ret = (OBR)this.get("OBR");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ROL getROL() {
        ROL ret = null;
        try {
            ret = (ROL)this.get("ROL");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ROL getROL(int rep) {
        ROL ret = null;
        try {
            ret = (ROL)this.get("ROL", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getROLReps() {
        int reps = -1;
        try {
            reps = this.getAll("ROL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public OML_O35_TIMING_PRIOR getTIMING_PRIOR() {
        OML_O35_TIMING_PRIOR ret = null;
        try {
            ret = (OML_O35_TIMING_PRIOR)this.get("TIMING_PRIOR");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OML_O35_TIMING_PRIOR getTIMING_PRIOR(int rep) {
        OML_O35_TIMING_PRIOR ret = null;
        try {
            ret = (OML_O35_TIMING_PRIOR)this.get("TIMING_PRIOR", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMING_PRIORReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING_PRIOR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<OML_O35_TIMING_PRIOR> getTIMING_PRIORAll() throws HL7Exception {
        return this.getAllAsList("TIMING_PRIOR", OML_O35_TIMING_PRIOR.class);
    }

    public void insertTIMING_PRIOR(OML_O35_TIMING_PRIOR structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_PRIOR", (Structure)structure, rep);
    }

    public OML_O35_TIMING_PRIOR insertTIMING_PRIOR(int rep) throws HL7Exception {
        return (OML_O35_TIMING_PRIOR)super.insertRepetition("TIMING_PRIOR", rep);
    }

    public OML_O35_TIMING_PRIOR removeTIMING_PRIOR(int rep) throws HL7Exception {
        return (OML_O35_TIMING_PRIOR)super.removeRepetition("TIMING_PRIOR", rep);
    }

    public OML_O35_OBSERVATION_PRIOR getOBSERVATION_PRIOR() {
        OML_O35_OBSERVATION_PRIOR ret = null;
        try {
            ret = (OML_O35_OBSERVATION_PRIOR)this.get("OBSERVATION_PRIOR");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OML_O35_OBSERVATION_PRIOR getOBSERVATION_PRIOR(int rep) {
        OML_O35_OBSERVATION_PRIOR ret = null;
        try {
            ret = (OML_O35_OBSERVATION_PRIOR)this.get("OBSERVATION_PRIOR", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATION_PRIORReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION_PRIOR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<OML_O35_OBSERVATION_PRIOR> getOBSERVATION_PRIORAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION_PRIOR", OML_O35_OBSERVATION_PRIOR.class);
    }

    public void insertOBSERVATION_PRIOR(OML_O35_OBSERVATION_PRIOR structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION_PRIOR", (Structure)structure, rep);
    }

    public OML_O35_OBSERVATION_PRIOR insertOBSERVATION_PRIOR(int rep) throws HL7Exception {
        return (OML_O35_OBSERVATION_PRIOR)super.insertRepetition("OBSERVATION_PRIOR", rep);
    }

    public OML_O35_OBSERVATION_PRIOR removeOBSERVATION_PRIOR(int rep) throws HL7Exception {
        return (OML_O35_OBSERVATION_PRIOR)super.removeRepetition("OBSERVATION_PRIOR", rep);
    }
}

