/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.OPL_O37_CONTAINER;
import ca.uhn.hl7v2.model.v26.group.OPL_O37_OBSERVATION_REQUEST;
import ca.uhn.hl7v2.model.v26.segment.OBX;
import ca.uhn.hl7v2.model.v26.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPL_O37_SPECIMEN
extends AbstractGroup {
    public OPL_O37_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false);
            this.add(OBX.class, false, true);
            this.add(OPL_O37_CONTAINER.class, false, true);
            this.add(OPL_O37_OBSERVATION_REQUEST.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating OPL_O37_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public SPM getSPM() {
        SPM ret = null;
        try {
            ret = (SPM)this.get("SPM");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBX getOBX() {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBX getOBX(int rep) {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBXReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBX").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public OPL_O37_CONTAINER getCONTAINER() {
        OPL_O37_CONTAINER ret = null;
        try {
            ret = (OPL_O37_CONTAINER)this.get("CONTAINER");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OPL_O37_CONTAINER getCONTAINER(int rep) {
        OPL_O37_CONTAINER ret = null;
        try {
            ret = (OPL_O37_CONTAINER)this.get("CONTAINER", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCONTAINERReps() {
        int reps = -1;
        try {
            reps = this.getAll("CONTAINER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<OPL_O37_CONTAINER> getCONTAINERAll() throws HL7Exception {
        return this.getAllAsList("CONTAINER", OPL_O37_CONTAINER.class);
    }

    public void insertCONTAINER(OPL_O37_CONTAINER structure, int rep) throws HL7Exception {
        super.insertRepetition("CONTAINER", (Structure)structure, rep);
    }

    public OPL_O37_CONTAINER insertCONTAINER(int rep) throws HL7Exception {
        return (OPL_O37_CONTAINER)super.insertRepetition("CONTAINER", rep);
    }

    public OPL_O37_CONTAINER removeCONTAINER(int rep) throws HL7Exception {
        return (OPL_O37_CONTAINER)super.removeRepetition("CONTAINER", rep);
    }

    public OPL_O37_OBSERVATION_REQUEST getOBSERVATION_REQUEST() {
        OPL_O37_OBSERVATION_REQUEST ret = null;
        try {
            ret = (OPL_O37_OBSERVATION_REQUEST)this.get("OBSERVATION_REQUEST");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OPL_O37_OBSERVATION_REQUEST getOBSERVATION_REQUEST(int rep) {
        OPL_O37_OBSERVATION_REQUEST ret = null;
        try {
            ret = (OPL_O37_OBSERVATION_REQUEST)this.get("OBSERVATION_REQUEST", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATION_REQUESTReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION_REQUEST").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<OPL_O37_OBSERVATION_REQUEST> getOBSERVATION_REQUESTAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION_REQUEST", OPL_O37_OBSERVATION_REQUEST.class);
    }

    public void insertOBSERVATION_REQUEST(OPL_O37_OBSERVATION_REQUEST structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION_REQUEST", (Structure)structure, rep);
    }

    public OPL_O37_OBSERVATION_REQUEST insertOBSERVATION_REQUEST(int rep) throws HL7Exception {
        return (OPL_O37_OBSERVATION_REQUEST)super.insertRepetition("OBSERVATION_REQUEST", rep);
    }

    public OPL_O37_OBSERVATION_REQUEST removeOBSERVATION_REQUEST(int rep) throws HL7Exception {
        return (OPL_O37_OBSERVATION_REQUEST)super.removeRepetition("OBSERVATION_REQUEST", rep);
    }
}

