/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.ORD_O04_ORDER_DIET;
import ca.uhn.hl7v2.model.v26.group.ORD_O04_ORDER_TRAY;
import ca.uhn.hl7v2.model.v26.group.ORD_O04_PATIENT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORD_O04_RESPONSE
extends AbstractGroup {
    public ORD_O04_RESPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORD_O04_PATIENT.class, false, false);
            this.add(ORD_O04_ORDER_DIET.class, true, true);
            this.add(ORD_O04_ORDER_TRAY.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating ORD_O04_RESPONSE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public ORD_O04_PATIENT getPATIENT() {
        ORD_O04_PATIENT ret = null;
        try {
            ret = (ORD_O04_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORD_O04_ORDER_DIET getORDER_DIET() {
        ORD_O04_ORDER_DIET ret = null;
        try {
            ret = (ORD_O04_ORDER_DIET)this.get("ORDER_DIET");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORD_O04_ORDER_DIET getORDER_DIET(int rep) {
        ORD_O04_ORDER_DIET ret = null;
        try {
            ret = (ORD_O04_ORDER_DIET)this.get("ORDER_DIET", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDER_DIETReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER_DIET").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ORD_O04_ORDER_DIET> getORDER_DIETAll() throws HL7Exception {
        return this.getAllAsList("ORDER_DIET", ORD_O04_ORDER_DIET.class);
    }

    public void insertORDER_DIET(ORD_O04_ORDER_DIET structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER_DIET", (Structure)structure, rep);
    }

    public ORD_O04_ORDER_DIET insertORDER_DIET(int rep) throws HL7Exception {
        return (ORD_O04_ORDER_DIET)super.insertRepetition("ORDER_DIET", rep);
    }

    public ORD_O04_ORDER_DIET removeORDER_DIET(int rep) throws HL7Exception {
        return (ORD_O04_ORDER_DIET)super.removeRepetition("ORDER_DIET", rep);
    }

    public ORD_O04_ORDER_TRAY getORDER_TRAY() {
        ORD_O04_ORDER_TRAY ret = null;
        try {
            ret = (ORD_O04_ORDER_TRAY)this.get("ORDER_TRAY");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORD_O04_ORDER_TRAY getORDER_TRAY(int rep) {
        ORD_O04_ORDER_TRAY ret = null;
        try {
            ret = (ORD_O04_ORDER_TRAY)this.get("ORDER_TRAY", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDER_TRAYReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER_TRAY").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ORD_O04_ORDER_TRAY> getORDER_TRAYAll() throws HL7Exception {
        return this.getAllAsList("ORDER_TRAY", ORD_O04_ORDER_TRAY.class);
    }

    public void insertORDER_TRAY(ORD_O04_ORDER_TRAY structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER_TRAY", (Structure)structure, rep);
    }

    public ORD_O04_ORDER_TRAY insertORDER_TRAY(int rep) throws HL7Exception {
        return (ORD_O04_ORDER_TRAY)super.insertRepetition("ORDER_TRAY", rep);
    }

    public ORD_O04_ORDER_TRAY removeORDER_TRAY(int rep) throws HL7Exception {
        return (ORD_O04_ORDER_TRAY)super.removeRepetition("ORDER_TRAY", rep);
    }
}

