/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.PPG_PCG_PROBLEM_OBSERVATION;
import ca.uhn.hl7v2.model.v26.group.PPG_PCG_PROBLEM_ROLE;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.PRB;
import ca.uhn.hl7v2.model.v26.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPG_PCG_PROBLEM
extends AbstractGroup {
    public PPG_PCG_PROBLEM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PRB.class, true, false);
            this.add(NTE.class, false, true);
            this.add(VAR.class, false, true);
            this.add(PPG_PCG_PROBLEM_ROLE.class, false, true);
            this.add(PPG_PCG_PROBLEM_OBSERVATION.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating PPG_PCG_PROBLEM - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PRB getPRB() {
        PRB ret = null;
        try {
            ret = (PRB)this.get("PRB");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VAR getVAR(int rep) {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getVARReps() {
        int reps = -1;
        try {
            reps = this.getAll("VAR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", (Structure)structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PPG_PCG_PROBLEM_ROLE getPROBLEM_ROLE() {
        PPG_PCG_PROBLEM_ROLE ret = null;
        try {
            ret = (PPG_PCG_PROBLEM_ROLE)this.get("PROBLEM_ROLE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPG_PCG_PROBLEM_ROLE getPROBLEM_ROLE(int rep) {
        PPG_PCG_PROBLEM_ROLE ret = null;
        try {
            ret = (PPG_PCG_PROBLEM_ROLE)this.get("PROBLEM_ROLE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPROBLEM_ROLEReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROBLEM_ROLE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<PPG_PCG_PROBLEM_ROLE> getPROBLEM_ROLEAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM_ROLE", PPG_PCG_PROBLEM_ROLE.class);
    }

    public void insertPROBLEM_ROLE(PPG_PCG_PROBLEM_ROLE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM_ROLE", (Structure)structure, rep);
    }

    public PPG_PCG_PROBLEM_ROLE insertPROBLEM_ROLE(int rep) throws HL7Exception {
        return (PPG_PCG_PROBLEM_ROLE)super.insertRepetition("PROBLEM_ROLE", rep);
    }

    public PPG_PCG_PROBLEM_ROLE removePROBLEM_ROLE(int rep) throws HL7Exception {
        return (PPG_PCG_PROBLEM_ROLE)super.removeRepetition("PROBLEM_ROLE", rep);
    }

    public PPG_PCG_PROBLEM_OBSERVATION getPROBLEM_OBSERVATION() {
        PPG_PCG_PROBLEM_OBSERVATION ret = null;
        try {
            ret = (PPG_PCG_PROBLEM_OBSERVATION)this.get("PROBLEM_OBSERVATION");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPG_PCG_PROBLEM_OBSERVATION getPROBLEM_OBSERVATION(int rep) {
        PPG_PCG_PROBLEM_OBSERVATION ret = null;
        try {
            ret = (PPG_PCG_PROBLEM_OBSERVATION)this.get("PROBLEM_OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPROBLEM_OBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROBLEM_OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<PPG_PCG_PROBLEM_OBSERVATION> getPROBLEM_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM_OBSERVATION", PPG_PCG_PROBLEM_OBSERVATION.class);
    }

    public void insertPROBLEM_OBSERVATION(PPG_PCG_PROBLEM_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM_OBSERVATION", (Structure)structure, rep);
    }

    public PPG_PCG_PROBLEM_OBSERVATION insertPROBLEM_OBSERVATION(int rep) throws HL7Exception {
        return (PPG_PCG_PROBLEM_OBSERVATION)super.insertRepetition("PROBLEM_OBSERVATION", rep);
    }

    public PPG_PCG_PROBLEM_OBSERVATION removePROBLEM_OBSERVATION(int rep) throws HL7Exception {
        return (PPG_PCG_PROBLEM_OBSERVATION)super.removeRepetition("PROBLEM_OBSERVATION", rep);
    }
}

