/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.RSP_E22_PSL_ITEM_INFO;
import ca.uhn.hl7v2.model.v26.segment.IVC;
import ca.uhn.hl7v2.model.v26.segment.PSG;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSP_E22_AUTHORIZATION_INFO
extends AbstractGroup {
    public RSP_E22_AUTHORIZATION_INFO(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(IVC.class, true, false);
            this.add(PSG.class, true, false);
            this.add(RSP_E22_PSL_ITEM_INFO.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating RSP_E22_AUTHORIZATION_INFO - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public IVC getIVC() {
        IVC ret = null;
        try {
            ret = (IVC)this.get("IVC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PSG getPSG() {
        PSG ret = null;
        try {
            ret = (PSG)this.get("PSG");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_E22_PSL_ITEM_INFO getPSL_ITEM_INFO() {
        RSP_E22_PSL_ITEM_INFO ret = null;
        try {
            ret = (RSP_E22_PSL_ITEM_INFO)this.get("PSL_ITEM_INFO");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_E22_PSL_ITEM_INFO getPSL_ITEM_INFO(int rep) {
        RSP_E22_PSL_ITEM_INFO ret = null;
        try {
            ret = (RSP_E22_PSL_ITEM_INFO)this.get("PSL_ITEM_INFO", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPSL_ITEM_INFOReps() {
        int reps = -1;
        try {
            reps = this.getAll("PSL_ITEM_INFO").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RSP_E22_PSL_ITEM_INFO> getPSL_ITEM_INFOAll() throws HL7Exception {
        return this.getAllAsList("PSL_ITEM_INFO", RSP_E22_PSL_ITEM_INFO.class);
    }

    public void insertPSL_ITEM_INFO(RSP_E22_PSL_ITEM_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("PSL_ITEM_INFO", (Structure)structure, rep);
    }

    public RSP_E22_PSL_ITEM_INFO insertPSL_ITEM_INFO(int rep) throws HL7Exception {
        return (RSP_E22_PSL_ITEM_INFO)super.insertRepetition("PSL_ITEM_INFO", rep);
    }

    public RSP_E22_PSL_ITEM_INFO removePSL_ITEM_INFO(int rep) throws HL7Exception {
        return (RSP_E22_PSL_ITEM_INFO)super.removeRepetition("PSL_ITEM_INFO", rep);
    }
}

