/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.MO;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import org.slf4j.LoggerFactory;

public class IIM
extends AbstractSegment {
    public IIM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 250, new Object[]{this.getMessage()}, "Primary Key Value - IIM");
            this.add(CWE.class, true, 1, 250, new Object[]{this.getMessage()}, "Service Item Code");
            this.add(ST.class, false, 1, 250, new Object[]{this.getMessage()}, "Inventory Lot Number");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Inventory Expiration Date");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Inventory Manufacturer Name");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Inventory Location");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Inventory Received Date");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Inventory Received Quantity");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Inventory Received Quantity Unit");
            this.add(MO.class, false, 1, 12, new Object[]{this.getMessage()}, "Inventory Received Item Cost");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Inventory On Hand Date");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Inventory On Hand Quantity");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Inventory On Hand Quantity Unit");
            this.add(CNE.class, false, 1, 705, new Object[]{this.getMessage()}, "Procedure Code");
            this.add(CNE.class, false, 0, 705, new Object[]{this.getMessage()}, "Procedure Code Modifier");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating IIM - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE getPrimaryKeyValueIIM() {
        CWE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getIim1_PrimaryKeyValueIIM() {
        CWE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getServiceItemCode() {
        CWE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getIim2_ServiceItemCode() {
        CWE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getInventoryLotNumber() {
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getIim3_InventoryLotNumber() {
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getInventoryExpirationDate() {
        DTM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getIim4_InventoryExpirationDate() {
        DTM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInventoryManufacturerName() {
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getIim5_InventoryManufacturerName() {
        CWE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInventoryLocation() {
        CWE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getIim6_InventoryLocation() {
        CWE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getInventoryReceivedDate() {
        DTM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getIim7_InventoryReceivedDate() {
        DTM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getInventoryReceivedQuantity() {
        NM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getIim8_InventoryReceivedQuantity() {
        NM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInventoryReceivedQuantityUnit() {
        CWE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getIim9_InventoryReceivedQuantityUnit() {
        CWE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public MO getInventoryReceivedItemCost() {
        MO ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (MO)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public MO getIim10_InventoryReceivedItemCost() {
        MO ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (MO)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getInventoryOnHandDate() {
        DTM ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getIim11_InventoryOnHandDate() {
        DTM ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getInventoryOnHandQuantity() {
        NM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getIim12_InventoryOnHandQuantity() {
        NM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInventoryOnHandQuantityUnit() {
        CWE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getIim13_InventoryOnHandQuantityUnit() {
        CWE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CNE getProcedureCode() {
        CNE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CNE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CNE getIim14_ProcedureCode() {
        CNE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CNE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CNE[] getProcedureCodeModifier() {
        CNE[] ret = null;
        try {
            Type[] t = this.getField(15);
            ret = new CNE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CNE)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getProcedureCodeModifierReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(15);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CNE getProcedureCodeModifier(int rep) {
        CNE ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (CNE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CNE getIim15_ProcedureCodeModifier(int rep) {
        CNE ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (CNE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIim15_ProcedureCodeModifierReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(15);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CNE insertProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(15, rep);
    }

    public CNE insertIim15_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(15, rep);
    }

    public CNE removeProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(15, rep);
    }

    public CNE removeIim15_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(15, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new DTM(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new DTM(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new MO(this.getMessage());
            }
            case 10: {
                return new DTM(this.getMessage());
            }
            case 11: {
                return new NM(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new CNE(this.getMessage());
            }
            case 14: {
                return new CNE(this.getMessage());
            }
        }
        return null;
    }
}

