/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.segment.DB1;
import ca.uhn.hl7v2.model.v26.segment.EVN;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.OBX;
import ca.uhn.hl7v2.model.v26.segment.PD1;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.model.v26.segment.PV1;
import ca.uhn.hl7v2.model.v26.segment.PV2;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADT_A17
extends AbstractMessage {
    public ADT_A17() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public ADT_A17(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(PV1.class, true, false);
            this.add(PV2.class, false, false);
            this.add(DB1.class, false, true);
            this.add(OBX.class, false, true);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(PV1.class, true, false);
            this.add(PV2.class, false, false);
            this.add(DB1.class, false, true);
            this.add(OBX.class, false, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ADT_A17 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public EVN getEVN() {
        return (EVN)this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return (PD1)this.getTyped("PD1", PD1.class);
    }

    public PV1 getPV1() {
        return (PV1)this.getTyped("PV1", PV1.class);
    }

    public PV2 getPV2() {
        return (PV2)this.getTyped("PV2", PV2.class);
    }

    public DB1 getDB1() {
        return (DB1)this.getTyped("DB1", DB1.class);
    }

    public DB1 getDB1(int rep) {
        return (DB1)this.getTyped("DB1", rep, DB1.class);
    }

    public int getDB1Reps() {
        return this.getReps("DB1");
    }

    public List<DB1> getDB1All() throws HL7Exception {
        return this.getAllAsList("DB1", DB1.class);
    }

    public void insertDB1(DB1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DB1", (Structure)structure, rep);
    }

    public DB1 insertDB1(int rep) throws HL7Exception {
        return (DB1)super.insertRepetition("DB1", rep);
    }

    public DB1 removeDB1(int rep) throws HL7Exception {
        return (DB1)super.removeRepetition("DB1", rep);
    }

    public OBX getOBX() {
        return (OBX)this.getTyped("OBX", OBX.class);
    }

    public OBX getOBX(int rep) {
        return (OBX)this.getTyped("OBX", rep, OBX.class);
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public PID getPID2() {
        return (PID)this.getTyped("PID2", PID.class);
    }

    public PD1 getPD12() {
        return (PD1)this.getTyped("PD12", PD1.class);
    }

    public PV1 getPV12() {
        return (PV1)this.getTyped("PV12", PV1.class);
    }

    public PV2 getPV22() {
        return (PV2)this.getTyped("PV22", PV2.class);
    }

    public DB1 getDB12() {
        return (DB1)this.getTyped("DB12", DB1.class);
    }

    public DB1 getDB12(int rep) {
        return (DB1)this.getTyped("DB12", rep, DB1.class);
    }

    public int getDB12Reps() {
        return this.getReps("DB12");
    }

    public List<DB1> getDB12All() throws HL7Exception {
        return this.getAllAsList("DB12", DB1.class);
    }

    public void insertDB12(DB1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DB12", (Structure)structure, rep);
    }

    public DB1 insertDB12(int rep) throws HL7Exception {
        return (DB1)super.insertRepetition("DB12", rep);
    }

    public DB1 removeDB12(int rep) throws HL7Exception {
        return (DB1)super.removeRepetition("DB12", rep);
    }

    public OBX getOBX2() {
        return (OBX)this.getTyped("OBX2", OBX.class);
    }

    public OBX getOBX2(int rep) {
        return (OBX)this.getTyped("OBX2", rep, OBX.class);
    }

    public int getOBX2Reps() {
        return this.getReps("OBX2");
    }

    public List<OBX> getOBX2All() throws HL7Exception {
        return this.getAllAsList("OBX2", OBX.class);
    }

    public void insertOBX2(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX2", (Structure)structure, rep);
    }

    public OBX insertOBX2(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX2", rep);
    }

    public OBX removeOBX2(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX2", rep);
    }
}

