/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DT;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class AL1
extends AbstractSegment {
    public AL1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - AL1");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Allergen Type Code");
            this.add(CWE.class, true, 1, 705, new Object[]{this.getMessage()}, "Allergen Code/Mnemonic/Description");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Allergy Severity Code");
            this.add(ST.class, false, 0, 15, new Object[]{this.getMessage()}, "Allergy Reaction Code");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Identification Date");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating AL1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDAL1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getAl11_SetIDAL1() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getAllergenTypeCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getAl12_AllergenTypeCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getAllergenCodeMnemonicDescription() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getAl13_AllergenCodeMnemonicDescription() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getAllergySeverityCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getAl14_AllergySeverityCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public ST[] getAllergyReactionCode() {
        ST[] retVal = (ST[])this.getTypedField(5, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getAl15_AllergyReactionCode() {
        ST[] retVal = (ST[])this.getTypedField(5, (Type[])new ST[0]);
        return retVal;
    }

    public int getAllergyReactionCodeReps() {
        return this.getReps(5);
    }

    public ST getAllergyReactionCode(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public ST getAl15_AllergyReactionCode(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public int getAl15_AllergyReactionCodeReps() {
        return this.getReps(5);
    }

    public ST insertAllergyReactionCode(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST insertAl15_AllergyReactionCode(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST removeAllergyReactionCode(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST removeAl15_AllergyReactionCode(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public DT getIdentificationDate() {
        DT retVal = (DT)this.getTypedField(6, 0);
        return retVal;
    }

    public DT getAl16_IdentificationDate() {
        DT retVal = (DT)this.getTypedField(6, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new DT(this.getMessage());
            }
        }
        return null;
    }
}

