/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.CX;
import ca.uhn.hl7v2.model.v26.datatype.DR;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ORG
extends AbstractSegment {
    public ORG(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 60, new Object[]{this.getMessage()}, "Set ID - ORG");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Organization Unit Code");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Organization Unit Type Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Primary Org Unit Indicator");
            this.add(CX.class, false, 1, 60, new Object[]{this.getMessage()}, "Practitioner Org Unit Identifier");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Health Care Provider Type Code");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Health Care Provider Classification Code");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Health Care Provider Area of Specialization Code");
            this.add(DR.class, false, 1, 52, new Object[]{this.getMessage()}, "Effective Date Range");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Employment Status Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Board Approval Indicator");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Primary Care Physician Indicator");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ORG - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDORG() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getOrg1_SetIDORG() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getOrganizationUnitCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getOrg2_OrganizationUnitCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getOrganizationUnitTypeCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getOrg3_OrganizationUnitTypeCode() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getPrimaryOrgUnitIndicator() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getOrg4_PrimaryOrgUnitIndicator() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public CX getPractitionerOrgUnitIdentifier() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public CX getOrg5_PractitionerOrgUnitIdentifier() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getHealthCareProviderTypeCode() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getOrg6_HealthCareProviderTypeCode() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getHealthCareProviderClassificationCode() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getOrg7_HealthCareProviderClassificationCode() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getHealthCareProviderAreaOfSpecializationCode() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getOrg8_HealthCareProviderAreaOfSpecializationCode() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public DR getEffectiveDateRange() {
        DR retVal = (DR)this.getTypedField(9, 0);
        return retVal;
    }

    public DR getOrg9_EffectiveDateRange() {
        DR retVal = (DR)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getEmploymentStatusCode() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getOrg10_EmploymentStatusCode() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getBoardApprovalIndicator() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getOrg11_BoardApprovalIndicator() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getPrimaryCarePhysicianIndicator() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getOrg12_PrimaryCarePhysicianIndicator() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 4: {
                return new CX(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new DR(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

