/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.RRA_O18_ORDER;
import ca.uhn.hl7v2.model.v26.group.RRA_O18_PATIENT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RRA_O18_RESPONSE
extends AbstractGroup {
    public RRA_O18_RESPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RRA_O18_PATIENT.class, false, false, false);
            this.add(RRA_O18_ORDER.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RRA_O18_RESPONSE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public RRA_O18_PATIENT getPATIENT() {
        RRA_O18_PATIENT retVal = (RRA_O18_PATIENT)this.getTyped("PATIENT", RRA_O18_PATIENT.class);
        return retVal;
    }

    public RRA_O18_ORDER getORDER() {
        RRA_O18_ORDER retVal = (RRA_O18_ORDER)this.getTyped("ORDER", RRA_O18_ORDER.class);
        return retVal;
    }

    public RRA_O18_ORDER getORDER(int rep) {
        RRA_O18_ORDER retVal = (RRA_O18_ORDER)this.getTyped("ORDER", rep, RRA_O18_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<RRA_O18_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", RRA_O18_ORDER.class);
    }

    public void insertORDER(RRA_O18_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public RRA_O18_ORDER insertORDER(int rep) throws HL7Exception {
        return (RRA_O18_ORDER)super.insertRepetition("ORDER", rep);
    }

    public RRA_O18_ORDER removeORDER(int rep) throws HL7Exception {
        return (RRA_O18_ORDER)super.removeRepetition("ORDER", rep);
    }
}

