/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.RDR_RDR_DEFINITION;
import ca.uhn.hl7v2.model.v26.segment.DSC;
import ca.uhn.hl7v2.model.v26.segment.ERR;
import ca.uhn.hl7v2.model.v26.segment.MSA;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.RXC;
import ca.uhn.hl7v2.model.v26.segment.RXD;
import ca.uhn.hl7v2.model.v26.segment.RXR;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDR_RDR
extends AbstractMessage {
    public RDR_RDR() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public RDR_RDR(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, true);
            this.add(SFT.class, false, true);
            this.add(SFT.class, false, false);
            this.add(UAC.class, false, false);
            this.add(RDR_RDR_DEFINITION.class, true, true);
            this.add(RXC.class, false, true);
            this.add(DSC.class, false, false);
            this.add(RXD.class, true, false);
            this.add(RXR.class, true, true);
            this.add(RXC.class, false, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RDR_RDR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public ERR getERR(int rep) {
        return (ERR)this.getTyped("ERR", rep, ERR.class);
    }

    public int getERRReps() {
        return this.getReps("ERR");
    }

    public List<ERR> getERRAll() throws HL7Exception {
        return this.getAllAsList("ERR", ERR.class);
    }

    public void insertERR(ERR structure, int rep) throws HL7Exception {
        super.insertRepetition("ERR", (Structure)structure, rep);
    }

    public ERR insertERR(int rep) throws HL7Exception {
        return (ERR)super.insertRepetition("ERR", rep);
    }

    public ERR removeERR(int rep) throws HL7Exception {
        return (ERR)super.removeRepetition("ERR", rep);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public SFT getSFT2() {
        return (SFT)this.getTyped("SFT2", SFT.class);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public RDR_RDR_DEFINITION getDEFINITION() {
        return (RDR_RDR_DEFINITION)this.getTyped("DEFINITION", RDR_RDR_DEFINITION.class);
    }

    public RDR_RDR_DEFINITION getDEFINITION(int rep) {
        return (RDR_RDR_DEFINITION)this.getTyped("DEFINITION", rep, RDR_RDR_DEFINITION.class);
    }

    public int getDEFINITIONReps() {
        return this.getReps("DEFINITION");
    }

    public List<RDR_RDR_DEFINITION> getDEFINITIONAll() throws HL7Exception {
        return this.getAllAsList("DEFINITION", RDR_RDR_DEFINITION.class);
    }

    public void insertDEFINITION(RDR_RDR_DEFINITION structure, int rep) throws HL7Exception {
        super.insertRepetition("DEFINITION", (Structure)structure, rep);
    }

    public RDR_RDR_DEFINITION insertDEFINITION(int rep) throws HL7Exception {
        return (RDR_RDR_DEFINITION)super.insertRepetition("DEFINITION", rep);
    }

    public RDR_RDR_DEFINITION removeDEFINITION(int rep) throws HL7Exception {
        return (RDR_RDR_DEFINITION)super.removeRepetition("DEFINITION", rep);
    }

    public RXC getRXC() {
        return (RXC)this.getTyped("RXC", RXC.class);
    }

    public RXC getRXC(int rep) {
        return (RXC)this.getTyped("RXC", rep, RXC.class);
    }

    public int getRXCReps() {
        return this.getReps("RXC");
    }

    public List<RXC> getRXCAll() throws HL7Exception {
        return this.getAllAsList("RXC", RXC.class);
    }

    public void insertRXC(RXC structure, int rep) throws HL7Exception {
        super.insertRepetition("RXC", (Structure)structure, rep);
    }

    public RXC insertRXC(int rep) throws HL7Exception {
        return (RXC)super.insertRepetition("RXC", rep);
    }

    public RXC removeRXC(int rep) throws HL7Exception {
        return (RXC)super.removeRepetition("RXC", rep);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }

    public RXD getRXD() {
        return (RXD)this.getTyped("RXD", RXD.class);
    }

    public RXR getRXR() {
        return (RXR)this.getTyped("RXR", RXR.class);
    }

    public RXR getRXR(int rep) {
        return (RXR)this.getTyped("RXR", rep, RXR.class);
    }

    public int getRXRReps() {
        return this.getReps("RXR");
    }

    public List<RXR> getRXRAll() throws HL7Exception {
        return this.getAllAsList("RXR", RXR.class);
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", (Structure)structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public RXC getRXC2() {
        return (RXC)this.getTyped("RXC2", RXC.class);
    }

    public RXC getRXC2(int rep) {
        return (RXC)this.getTyped("RXC2", rep, RXC.class);
    }

    public int getRXC2Reps() {
        return this.getReps("RXC2");
    }

    public List<RXC> getRXC2All() throws HL7Exception {
        return this.getAllAsList("RXC2", RXC.class);
    }

    public void insertRXC2(RXC structure, int rep) throws HL7Exception {
        super.insertRepetition("RXC2", (Structure)structure, rep);
    }

    public RXC insertRXC2(int rep) throws HL7Exception {
        return (RXC)super.insertRepetition("RXC2", rep);
    }

    public RXC removeRXC2(int rep) throws HL7Exception {
        return (RXC)super.removeRepetition("RXC2", rep);
    }

    public DSC getDSC2() {
        return (DSC)this.getTyped("DSC2", DSC.class);
    }
}

