/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.PL;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.XAD;
import ca.uhn.hl7v2.model.v26.datatype.XON;
import ca.uhn.hl7v2.model.v26.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class LOC
extends AbstractSegment {
    public LOC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PL.class, true, 1, 200, new Object[]{this.getMessage()}, "Primary Key Value - LOC");
            this.add(ST.class, false, 1, 48, new Object[]{this.getMessage()}, "Location Description");
            this.add(IS.class, true, 0, 2, new Object[]{this.getMessage(), new Integer(260)}, "Location Type - LOC");
            this.add(XON.class, false, 0, 250, new Object[]{this.getMessage()}, "Organization Name - LOC");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage()}, "Location Address");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage()}, "Location Phone");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "License Number");
            this.add(IS.class, false, 0, 3, new Object[]{this.getMessage(), new Integer(261)}, "Location Equipment");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(442)}, "Location Service Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating LOC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public PL getPrimaryKeyValueLOC() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public PL getLoc1_PrimaryKeyValueLOC() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getLocationDescription() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getLoc2_LocationDescription() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public IS[] getLocationTypeLOC() {
        IS[] retVal = (IS[])this.getTypedField(3, (Type[])new IS[0]);
        return retVal;
    }

    public IS[] getLoc3_LocationTypeLOC() {
        IS[] retVal = (IS[])this.getTypedField(3, (Type[])new IS[0]);
        return retVal;
    }

    public int getLocationTypeLOCReps() {
        return this.getReps(3);
    }

    public IS getLocationTypeLOC(int rep) {
        IS retVal = (IS)this.getTypedField(3, rep);
        return retVal;
    }

    public IS getLoc3_LocationTypeLOC(int rep) {
        IS retVal = (IS)this.getTypedField(3, rep);
        return retVal;
    }

    public int getLoc3_LocationTypeLOCReps() {
        return this.getReps(3);
    }

    public IS insertLocationTypeLOC(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(3, rep);
    }

    public IS insertLoc3_LocationTypeLOC(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(3, rep);
    }

    public IS removeLocationTypeLOC(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(3, rep);
    }

    public IS removeLoc3_LocationTypeLOC(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(3, rep);
    }

    public XON[] getOrganizationNameLOC() {
        XON[] retVal = (XON[])this.getTypedField(4, (Type[])new XON[0]);
        return retVal;
    }

    public XON[] getLoc4_OrganizationNameLOC() {
        XON[] retVal = (XON[])this.getTypedField(4, (Type[])new XON[0]);
        return retVal;
    }

    public int getOrganizationNameLOCReps() {
        return this.getReps(4);
    }

    public XON getOrganizationNameLOC(int rep) {
        XON retVal = (XON)this.getTypedField(4, rep);
        return retVal;
    }

    public XON getLoc4_OrganizationNameLOC(int rep) {
        XON retVal = (XON)this.getTypedField(4, rep);
        return retVal;
    }

    public int getLoc4_OrganizationNameLOCReps() {
        return this.getReps(4);
    }

    public XON insertOrganizationNameLOC(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(4, rep);
    }

    public XON insertLoc4_OrganizationNameLOC(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(4, rep);
    }

    public XON removeOrganizationNameLOC(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(4, rep);
    }

    public XON removeLoc4_OrganizationNameLOC(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(4, rep);
    }

    public XAD[] getLocationAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(5, (Type[])new XAD[0]);
        return retVal;
    }

    public XAD[] getLoc5_LocationAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(5, (Type[])new XAD[0]);
        return retVal;
    }

    public int getLocationAddressReps() {
        return this.getReps(5);
    }

    public XAD getLocationAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(5, rep);
        return retVal;
    }

    public XAD getLoc5_LocationAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(5, rep);
        return retVal;
    }

    public int getLoc5_LocationAddressReps() {
        return this.getReps(5);
    }

    public XAD insertLocationAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(5, rep);
    }

    public XAD insertLoc5_LocationAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(5, rep);
    }

    public XAD removeLocationAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(5, rep);
    }

    public XAD removeLoc5_LocationAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(5, rep);
    }

    public XTN[] getLocationPhone() {
        XTN[] retVal = (XTN[])this.getTypedField(6, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getLoc6_LocationPhone() {
        XTN[] retVal = (XTN[])this.getTypedField(6, (Type[])new XTN[0]);
        return retVal;
    }

    public int getLocationPhoneReps() {
        return this.getReps(6);
    }

    public XTN getLocationPhone(int rep) {
        XTN retVal = (XTN)this.getTypedField(6, rep);
        return retVal;
    }

    public XTN getLoc6_LocationPhone(int rep) {
        XTN retVal = (XTN)this.getTypedField(6, rep);
        return retVal;
    }

    public int getLoc6_LocationPhoneReps() {
        return this.getReps(6);
    }

    public XTN insertLocationPhone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(6, rep);
    }

    public XTN insertLoc6_LocationPhone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(6, rep);
    }

    public XTN removeLocationPhone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(6, rep);
    }

    public XTN removeLoc6_LocationPhone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(6, rep);
    }

    public CWE[] getLicenseNumber() {
        CWE[] retVal = (CWE[])this.getTypedField(7, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getLoc7_LicenseNumber() {
        CWE[] retVal = (CWE[])this.getTypedField(7, (Type[])new CWE[0]);
        return retVal;
    }

    public int getLicenseNumberReps() {
        return this.getReps(7);
    }

    public CWE getLicenseNumber(int rep) {
        CWE retVal = (CWE)this.getTypedField(7, rep);
        return retVal;
    }

    public CWE getLoc7_LicenseNumber(int rep) {
        CWE retVal = (CWE)this.getTypedField(7, rep);
        return retVal;
    }

    public int getLoc7_LicenseNumberReps() {
        return this.getReps(7);
    }

    public CWE insertLicenseNumber(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(7, rep);
    }

    public CWE insertLoc7_LicenseNumber(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(7, rep);
    }

    public CWE removeLicenseNumber(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(7, rep);
    }

    public CWE removeLoc7_LicenseNumber(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(7, rep);
    }

    public IS[] getLocationEquipment() {
        IS[] retVal = (IS[])this.getTypedField(8, (Type[])new IS[0]);
        return retVal;
    }

    public IS[] getLoc8_LocationEquipment() {
        IS[] retVal = (IS[])this.getTypedField(8, (Type[])new IS[0]);
        return retVal;
    }

    public int getLocationEquipmentReps() {
        return this.getReps(8);
    }

    public IS getLocationEquipment(int rep) {
        IS retVal = (IS)this.getTypedField(8, rep);
        return retVal;
    }

    public IS getLoc8_LocationEquipment(int rep) {
        IS retVal = (IS)this.getTypedField(8, rep);
        return retVal;
    }

    public int getLoc8_LocationEquipmentReps() {
        return this.getReps(8);
    }

    public IS insertLocationEquipment(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(8, rep);
    }

    public IS insertLoc8_LocationEquipment(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(8, rep);
    }

    public IS removeLocationEquipment(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(8, rep);
    }

    public IS removeLoc8_LocationEquipment(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(8, rep);
    }

    public IS getLocationServiceCode() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public IS getLoc9_LocationServiceCode() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new PL(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new IS(this.getMessage(), new Integer(260));
            }
            case 3: {
                return new XON(this.getMessage());
            }
            case 4: {
                return new XAD(this.getMessage());
            }
            case 5: {
                return new XTN(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new IS(this.getMessage(), new Integer(261));
            }
            case 8: {
                return new IS(this.getMessage(), new Integer(442));
            }
        }
        return null;
    }
}

