/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.ORS_O06_TIMING;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ca.uhn.hl7v2.model.v26.segment.RQ1;
import ca.uhn.hl7v2.model.v26.segment.RQD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORS_O06_ORDER
extends AbstractGroup {
    public ORS_O06_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(ORS_O06_TIMING.class, false, true, false);
            this.add(RQD.class, true, false, false);
            this.add(RQ1.class, false, false, false);
            this.add(NTE.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORS_O06_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public ORS_O06_TIMING getTIMING() {
        ORS_O06_TIMING retVal = (ORS_O06_TIMING)this.getTyped("TIMING", ORS_O06_TIMING.class);
        return retVal;
    }

    public ORS_O06_TIMING getTIMING(int rep) {
        ORS_O06_TIMING retVal = (ORS_O06_TIMING)this.getTyped("TIMING", rep, ORS_O06_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<ORS_O06_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", ORS_O06_TIMING.class);
    }

    public void insertTIMING(ORS_O06_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public ORS_O06_TIMING insertTIMING(int rep) throws HL7Exception {
        return (ORS_O06_TIMING)super.insertRepetition("TIMING", rep);
    }

    public ORS_O06_TIMING removeTIMING(int rep) throws HL7Exception {
        return (ORS_O06_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RQD getRQD() {
        RQD retVal = (RQD)this.getTyped("RQD", RQD.class);
        return retVal;
    }

    public RQ1 getRQ1() {
        RQ1 retVal = (RQ1)this.getTyped("RQ1", RQ1.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

