/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.segment.IAM;
import ca.uhn.hl7v2.model.v27.segment.IAR;
import ca.uhn.hl7v2.model.v27.segment.NTE;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ADT_A60_ADVERSE_REACTION_GROUP
extends AbstractGroup {
    public ADT_A60_ADVERSE_REACTION_GROUP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(IAM.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(IAR.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADT_A60_ADVERSE_REACTION_GROUP - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public IAM getIAM() {
        IAM retVal = (IAM)this.getTyped("IAM", IAM.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public IAR getIAR() {
        IAR retVal = (IAR)this.getTyped("IAR", IAR.class);
        return retVal;
    }

    public IAR getIAR(int rep) {
        IAR retVal = (IAR)this.getTyped("IAR", rep, IAR.class);
        return retVal;
    }

    public int getIARReps() {
        return this.getReps("IAR");
    }

    public List<IAR> getIARAll() throws HL7Exception {
        return this.getAllAsList("IAR", IAR.class);
    }

    public void insertIAR(IAR structure, int rep) throws HL7Exception {
        super.insertRepetition("IAR", (Structure)structure, rep);
    }

    public IAR insertIAR(int rep) throws HL7Exception {
        return (IAR)super.insertRepetition("IAR", rep);
    }

    public IAR removeIAR(int rep) throws HL7Exception {
        return (IAR)super.removeRepetition("IAR", rep);
    }
}

