/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.CCM_I21_ROLE_PATHWAY;
import ca.uhn.hl7v2.model.v27.segment.OBX;
import ca.uhn.hl7v2.model.v27.segment.PTH;
import ca.uhn.hl7v2.model.v27.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CCM_I21_PATHWAY
extends AbstractGroup {
    public CCM_I21_PATHWAY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PTH.class, true, false, false);
            this.add(VAR.class, false, true, false);
            this.add(CCM_I21_ROLE_PATHWAY.class, false, true, false);
            this.add(OBX.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CCM_I21_PATHWAY - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public PTH getPTH() {
        PTH retVal = (PTH)this.getTyped("PTH", PTH.class);
        return retVal;
    }

    public VAR getVAR() {
        VAR retVal = (VAR)this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = (VAR)this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", (Structure)structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public CCM_I21_ROLE_PATHWAY getROLE_PATHWAY() {
        CCM_I21_ROLE_PATHWAY retVal = (CCM_I21_ROLE_PATHWAY)this.getTyped("ROLE_PATHWAY", CCM_I21_ROLE_PATHWAY.class);
        return retVal;
    }

    public CCM_I21_ROLE_PATHWAY getROLE_PATHWAY(int rep) {
        CCM_I21_ROLE_PATHWAY retVal = (CCM_I21_ROLE_PATHWAY)this.getTyped("ROLE_PATHWAY", rep, CCM_I21_ROLE_PATHWAY.class);
        return retVal;
    }

    public int getROLE_PATHWAYReps() {
        return this.getReps("ROLE_PATHWAY");
    }

    public List<CCM_I21_ROLE_PATHWAY> getROLE_PATHWAYAll() throws HL7Exception {
        return this.getAllAsList("ROLE_PATHWAY", CCM_I21_ROLE_PATHWAY.class);
    }

    public void insertROLE_PATHWAY(CCM_I21_ROLE_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("ROLE_PATHWAY", (Structure)structure, rep);
    }

    public CCM_I21_ROLE_PATHWAY insertROLE_PATHWAY(int rep) throws HL7Exception {
        return (CCM_I21_ROLE_PATHWAY)super.insertRepetition("ROLE_PATHWAY", rep);
    }

    public CCM_I21_ROLE_PATHWAY removeROLE_PATHWAY(int rep) throws HL7Exception {
        return (CCM_I21_ROLE_PATHWAY)super.removeRepetition("ROLE_PATHWAY", rep);
    }

    public OBX getOBX() {
        OBX retVal = (OBX)this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = (OBX)this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }
}

