/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.OML_O33_ORDER;
import ca.uhn.hl7v2.model.v27.group.OML_O33_SPECIMEN_OBSERVATION;
import ca.uhn.hl7v2.model.v27.segment.SAC;
import ca.uhn.hl7v2.model.v27.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OML_O33_SPECIMEN
extends AbstractGroup {
    public OML_O33_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false, false);
            this.add(OML_O33_SPECIMEN_OBSERVATION.class, false, true, false);
            this.add(SAC.class, false, true, false);
            this.add(OML_O33_ORDER.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OML_O33_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public SPM getSPM() {
        SPM retVal = (SPM)this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public OML_O33_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION() {
        OML_O33_SPECIMEN_OBSERVATION retVal = (OML_O33_SPECIMEN_OBSERVATION)this.getTyped("SPECIMEN_OBSERVATION", OML_O33_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public OML_O33_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION(int rep) {
        OML_O33_SPECIMEN_OBSERVATION retVal = (OML_O33_SPECIMEN_OBSERVATION)this.getTyped("SPECIMEN_OBSERVATION", rep, OML_O33_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public int getSPECIMEN_OBSERVATIONReps() {
        return this.getReps("SPECIMEN_OBSERVATION");
    }

    public List<OML_O33_SPECIMEN_OBSERVATION> getSPECIMEN_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_OBSERVATION", OML_O33_SPECIMEN_OBSERVATION.class);
    }

    public void insertSPECIMEN_OBSERVATION(OML_O33_SPECIMEN_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_OBSERVATION", (Structure)structure, rep);
    }

    public OML_O33_SPECIMEN_OBSERVATION insertSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OML_O33_SPECIMEN_OBSERVATION)super.insertRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OML_O33_SPECIMEN_OBSERVATION removeSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OML_O33_SPECIMEN_OBSERVATION)super.removeRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public SAC getSAC() {
        SAC retVal = (SAC)this.getTyped("SAC", SAC.class);
        return retVal;
    }

    public SAC getSAC(int rep) {
        SAC retVal = (SAC)this.getTyped("SAC", rep, SAC.class);
        return retVal;
    }

    public int getSACReps() {
        return this.getReps("SAC");
    }

    public List<SAC> getSACAll() throws HL7Exception {
        return this.getAllAsList("SAC", SAC.class);
    }

    public void insertSAC(SAC structure, int rep) throws HL7Exception {
        super.insertRepetition("SAC", (Structure)structure, rep);
    }

    public SAC insertSAC(int rep) throws HL7Exception {
        return (SAC)super.insertRepetition("SAC", rep);
    }

    public SAC removeSAC(int rep) throws HL7Exception {
        return (SAC)super.removeRepetition("SAC", rep);
    }

    public OML_O33_ORDER getORDER() {
        OML_O33_ORDER retVal = (OML_O33_ORDER)this.getTyped("ORDER", OML_O33_ORDER.class);
        return retVal;
    }

    public OML_O33_ORDER getORDER(int rep) {
        OML_O33_ORDER retVal = (OML_O33_ORDER)this.getTyped("ORDER", rep, OML_O33_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<OML_O33_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", OML_O33_ORDER.class);
    }

    public void insertORDER(OML_O33_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public OML_O33_ORDER insertORDER(int rep) throws HL7Exception {
        return (OML_O33_ORDER)super.insertRepetition("ORDER", rep);
    }

    public OML_O33_ORDER removeORDER(int rep) throws HL7Exception {
        return (OML_O33_ORDER)super.removeRepetition("ORDER", rep);
    }
}

