/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.MFN_M02_MF_STAFF;
import ca.uhn.hl7v2.model.v27.segment.MFI;
import ca.uhn.hl7v2.model.v27.segment.MSH;
import ca.uhn.hl7v2.model.v27.segment.SFT;
import ca.uhn.hl7v2.model.v27.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M02
extends AbstractMessage {
    public MFN_M02() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFN_M02(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M02_MF_STAFF.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M02 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public MFI getMFI() {
        return (MFI)this.getTyped("MFI", MFI.class);
    }

    public MFN_M02_MF_STAFF getMF_STAFF() {
        return (MFN_M02_MF_STAFF)this.getTyped("MF_STAFF", MFN_M02_MF_STAFF.class);
    }

    public MFN_M02_MF_STAFF getMF_STAFF(int rep) {
        return (MFN_M02_MF_STAFF)this.getTyped("MF_STAFF", rep, MFN_M02_MF_STAFF.class);
    }

    public int getMF_STAFFReps() {
        return this.getReps("MF_STAFF");
    }

    public List<MFN_M02_MF_STAFF> getMF_STAFFAll() throws HL7Exception {
        return this.getAllAsList("MF_STAFF", MFN_M02_MF_STAFF.class);
    }

    public void insertMF_STAFF(MFN_M02_MF_STAFF structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_STAFF", (Structure)structure, rep);
    }

    public MFN_M02_MF_STAFF insertMF_STAFF(int rep) throws HL7Exception {
        return (MFN_M02_MF_STAFF)super.insertRepetition("MF_STAFF", rep);
    }

    public MFN_M02_MF_STAFF removeMF_STAFF(int rep) throws HL7Exception {
        return (MFN_M02_MF_STAFF)super.removeRepetition("MF_STAFF", rep);
    }
}

