/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.ID;
import ca.uhn.hl7v2.model.v27.datatype.NM;
import ca.uhn.hl7v2.model.v27.datatype.NULLDT;
import ca.uhn.hl7v2.model.v27.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ECD
extends AbstractSegment {
    public ECD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 0, new Object[]{this.getMessage()}, "Reference Command Number");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Remote Control Command");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Response Required");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Requested Completion Time");
            this.add(TX.class, false, 0, 0, new Object[]{this.getMessage()}, "Parameters");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ECD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getReferenceCommandNumber() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getEcd1_ReferenceCommandNumber() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getRemoteControlCommand() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getEcd2_RemoteControlCommand() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getResponseRequired() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getEcd3_ResponseRequired() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public NULLDT getRequestedCompletionTime() {
        NULLDT retVal = (NULLDT)this.getTypedField(4, 0);
        return retVal;
    }

    public NULLDT getEcd4_RequestedCompletionTime() {
        NULLDT retVal = (NULLDT)this.getTypedField(4, 0);
        return retVal;
    }

    public TX[] getParameters() {
        TX[] retVal = (TX[])this.getTypedField(5, (Type[])new TX[0]);
        return retVal;
    }

    public TX[] getEcd5_Parameters() {
        TX[] retVal = (TX[])this.getTypedField(5, (Type[])new TX[0]);
        return retVal;
    }

    public int getParametersReps() {
        return this.getReps(5);
    }

    public TX getParameters(int rep) {
        TX retVal = (TX)this.getTypedField(5, rep);
        return retVal;
    }

    public TX getEcd5_Parameters(int rep) {
        TX retVal = (TX)this.getTypedField(5, rep);
        return retVal;
    }

    public int getEcd5_ParametersReps() {
        return this.getReps(5);
    }

    public TX insertParameters(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(5, rep);
    }

    public TX insertEcd5_Parameters(int rep) throws HL7Exception {
        return (TX)super.insertRepetition(5, rep);
    }

    public TX removeParameters(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(5, rep);
    }

    public TX removeEcd5_Parameters(int rep) throws HL7Exception {
        return (TX)super.removeRepetition(5, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 3: {
                return new NULLDT(this.getMessage());
            }
            case 4: {
                return new TX(this.getMessage());
            }
        }
        return null;
    }
}

