/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.DTM;
import ca.uhn.hl7v2.model.v27.datatype.ID;
import ca.uhn.hl7v2.model.v27.datatype.PL;
import ca.uhn.hl7v2.model.v27.datatype.ST;
import ca.uhn.hl7v2.model.v27.datatype.VH;
import ca.uhn.hl7v2.model.v27.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class LDP
extends AbstractSegment {
    public LDP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PL.class, true, 1, 0, new Object[]{this.getMessage()}, "Primary Key Value - LDP");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Location Department");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Location Service");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Specialty Type");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Valid Patient Classes");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(183)}, "Active/Inactive Flag");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Activation Date - LDP");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Inactivation Date - LDP");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Inactivated Reason");
            this.add(VH.class, false, 0, 0, new Object[]{this.getMessage()}, "Visiting Hours");
            this.add(XTN.class, false, 1, 0, new Object[]{this.getMessage()}, "Contact Phone");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Location Cost Center");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating LDP - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public PL getPrimaryKeyValueLDP() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public PL getLdp1_PrimaryKeyValueLDP() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getLocationDepartment() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getLdp2_LocationDepartment() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE[] getLocationService() {
        CWE[] retVal = (CWE[])this.getTypedField(3, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getLdp3_LocationService() {
        CWE[] retVal = (CWE[])this.getTypedField(3, (Type[])new CWE[0]);
        return retVal;
    }

    public int getLocationServiceReps() {
        return this.getReps(3);
    }

    public CWE getLocationService(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public CWE getLdp3_LocationService(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getLdp3_LocationServiceReps() {
        return this.getReps(3);
    }

    public CWE insertLocationService(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE insertLdp3_LocationService(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE removeLocationService(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE removeLdp3_LocationService(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE[] getSpecialtyType() {
        CWE[] retVal = (CWE[])this.getTypedField(4, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getLdp4_SpecialtyType() {
        CWE[] retVal = (CWE[])this.getTypedField(4, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSpecialtyTypeReps() {
        return this.getReps(4);
    }

    public CWE getSpecialtyType(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public CWE getLdp4_SpecialtyType(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getLdp4_SpecialtyTypeReps() {
        return this.getReps(4);
    }

    public CWE insertSpecialtyType(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE insertLdp4_SpecialtyType(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE removeSpecialtyType(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CWE removeLdp4_SpecialtyType(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CWE[] getValidPatientClasses() {
        CWE[] retVal = (CWE[])this.getTypedField(5, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getLdp5_ValidPatientClasses() {
        CWE[] retVal = (CWE[])this.getTypedField(5, (Type[])new CWE[0]);
        return retVal;
    }

    public int getValidPatientClassesReps() {
        return this.getReps(5);
    }

    public CWE getValidPatientClasses(int rep) {
        CWE retVal = (CWE)this.getTypedField(5, rep);
        return retVal;
    }

    public CWE getLdp5_ValidPatientClasses(int rep) {
        CWE retVal = (CWE)this.getTypedField(5, rep);
        return retVal;
    }

    public int getLdp5_ValidPatientClassesReps() {
        return this.getReps(5);
    }

    public CWE insertValidPatientClasses(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(5, rep);
    }

    public CWE insertLdp5_ValidPatientClasses(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(5, rep);
    }

    public CWE removeValidPatientClasses(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(5, rep);
    }

    public CWE removeLdp5_ValidPatientClasses(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(5, rep);
    }

    public ID getActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getLdp6_ActiveInactiveFlag() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getActivationDateLDP() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getLdp7_ActivationDateLDP() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getInactivationDateLDP() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getLdp8_InactivationDateLDP() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getInactivatedReason() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getLdp9_InactivatedReason() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public VH[] getVisitingHours() {
        VH[] retVal = (VH[])this.getTypedField(10, (Type[])new VH[0]);
        return retVal;
    }

    public VH[] getLdp10_VisitingHours() {
        VH[] retVal = (VH[])this.getTypedField(10, (Type[])new VH[0]);
        return retVal;
    }

    public int getVisitingHoursReps() {
        return this.getReps(10);
    }

    public VH getVisitingHours(int rep) {
        VH retVal = (VH)this.getTypedField(10, rep);
        return retVal;
    }

    public VH getLdp10_VisitingHours(int rep) {
        VH retVal = (VH)this.getTypedField(10, rep);
        return retVal;
    }

    public int getLdp10_VisitingHoursReps() {
        return this.getReps(10);
    }

    public VH insertVisitingHours(int rep) throws HL7Exception {
        return (VH)super.insertRepetition(10, rep);
    }

    public VH insertLdp10_VisitingHours(int rep) throws HL7Exception {
        return (VH)super.insertRepetition(10, rep);
    }

    public VH removeVisitingHours(int rep) throws HL7Exception {
        return (VH)super.removeRepetition(10, rep);
    }

    public VH removeLdp10_VisitingHours(int rep) throws HL7Exception {
        return (VH)super.removeRepetition(10, rep);
    }

    public XTN getContactPhone() {
        XTN retVal = (XTN)this.getTypedField(11, 0);
        return retVal;
    }

    public XTN getLdp11_ContactPhone() {
        XTN retVal = (XTN)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getLocationCostCenter() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getLdp12_LocationCostCenter() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new PL(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(183));
            }
            case 6: {
                return new DTM(this.getMessage());
            }
            case 7: {
                return new DTM(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new VH(this.getMessage());
            }
            case 10: {
                return new XTN(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

