/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.CX;
import ca.uhn.hl7v2.model.v27.datatype.DT;
import ca.uhn.hl7v2.model.v27.datatype.NM;
import ca.uhn.hl7v2.model.v27.datatype.SI;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RQD
extends AbstractSegment {
    public RQD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Requisition Line Number");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Item Code - Internal");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Item Code - External");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Hospital Item Code");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Requisition Quantity");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Requisition Unit of Measure");
            this.add(CX.class, false, 1, 0, new Object[]{this.getMessage()}, "Cost Center Account Number");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Item Natural Account Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Deliver To ID");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Date Needed");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RQD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getRequisitionLineNumber() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getRqd1_RequisitionLineNumber() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getItemCodeInternal() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getRqd2_ItemCodeInternal() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getItemCodeExternal() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getRqd3_ItemCodeExternal() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getHospitalItemCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getRqd4_HospitalItemCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getRequisitionQuantity() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getRqd5_RequisitionQuantity() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getRequisitionUnitOfMeasure() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getRqd6_RequisitionUnitOfMeasure() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CX getCostCenterAccountNumber() {
        CX retVal = (CX)this.getTypedField(7, 0);
        return retVal;
    }

    public CX getRqd7_CostCenterAccountNumber() {
        CX retVal = (CX)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getItemNaturalAccountCode() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getRqd8_ItemNaturalAccountCode() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getDeliverToID() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getRqd9_DeliverToID() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public DT getDateNeeded() {
        DT retVal = (DT)this.getTypedField(10, 0);
        return retVal;
    }

    public DT getRqd10_DateNeeded() {
        DT retVal = (DT)this.getTypedField(10, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CX(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new DT(this.getMessage());
            }
        }
        return null;
    }
}

