/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.DT;
import ca.uhn.hl7v2.model.v28.datatype.ST;

public class DLN
extends AbstractComposite {
    private Type[] data;

    public DLN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[3];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new CWE(this.getMessage());
        this.data[2] = new DT(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getLicenseNumber() {
        return (ST)this.getTyped(0, ST.class);
    }

    public ST getDln1_LicenseNumber() {
        return (ST)this.getTyped(0, ST.class);
    }

    public CWE getIssuingStateProvinceCountry() {
        return (CWE)this.getTyped(1, CWE.class);
    }

    public CWE getDln2_IssuingStateProvinceCountry() {
        return (CWE)this.getTyped(1, CWE.class);
    }

    public DT getExpirationDate() {
        return (DT)this.getTyped(2, DT.class);
    }

    public DT getDln3_ExpirationDate() {
        return (DT)this.getTyped(2, DT.class);
    }
}

