/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION;
import ca.uhn.hl7v2.model.v28.segment.RXA;
import ca.uhn.hl7v2.model.v28.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CQU_I19_MEDICATION_ADMINISTRATION_DETAIL
extends AbstractGroup {
    public CQU_I19_MEDICATION_ADMINISTRATION_DETAIL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RXA.class, true, true, false);
            this.add(RXR.class, true, false, false);
            this.add(CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CQU_I19_MEDICATION_ADMINISTRATION_DETAIL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public RXA getRXA() {
        RXA retVal = (RXA)this.getTyped("RXA", RXA.class);
        return retVal;
    }

    public RXA getRXA(int rep) {
        RXA retVal = (RXA)this.getTyped("RXA", rep, RXA.class);
        return retVal;
    }

    public int getRXAReps() {
        return this.getReps("RXA");
    }

    public List<RXA> getRXAAll() throws HL7Exception {
        return this.getAllAsList("RXA", RXA.class);
    }

    public void insertRXA(RXA structure, int rep) throws HL7Exception {
        super.insertRepetition("RXA", (Structure)structure, rep);
    }

    public RXA insertRXA(int rep) throws HL7Exception {
        return (RXA)super.insertRepetition("RXA", rep);
    }

    public RXA removeRXA(int rep) throws HL7Exception {
        return (RXA)super.removeRepetition("RXA", rep);
    }

    public RXR getRXR() {
        RXR retVal = (RXR)this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION getMEDICATION_ADMINISTRATION_OBSERVATION() {
        CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION retVal = (CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION)this.getTyped("MEDICATION_ADMINISTRATION_OBSERVATION", CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION.class);
        return retVal;
    }

    public CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION getMEDICATION_ADMINISTRATION_OBSERVATION(int rep) {
        CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION retVal = (CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION)this.getTyped("MEDICATION_ADMINISTRATION_OBSERVATION", rep, CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION.class);
        return retVal;
    }

    public int getMEDICATION_ADMINISTRATION_OBSERVATIONReps() {
        return this.getReps("MEDICATION_ADMINISTRATION_OBSERVATION");
    }

    public List<CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION> getMEDICATION_ADMINISTRATION_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("MEDICATION_ADMINISTRATION_OBSERVATION", CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION.class);
    }

    public void insertMEDICATION_ADMINISTRATION_OBSERVATION(CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("MEDICATION_ADMINISTRATION_OBSERVATION", (Structure)structure, rep);
    }

    public CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION insertMEDICATION_ADMINISTRATION_OBSERVATION(int rep) throws HL7Exception {
        return (CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION)super.insertRepetition("MEDICATION_ADMINISTRATION_OBSERVATION", rep);
    }

    public CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION removeMEDICATION_ADMINISTRATION_OBSERVATION(int rep) throws HL7Exception {
        return (CQU_I19_MEDICATION_ADMINISTRATION_OBSERVATION)super.removeRepetition("MEDICATION_ADMINISTRATION_OBSERVATION", rep);
    }
}

